/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.niagaraSystemIndex.BReachableStationSystemIndexDeviceExt;
import com.tridium.systemIndex.SystemIndexLog;
import com.tridium.util.ComponentTreeCursor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:ReachableStations"})})
@NiagaraProperty(name="reachableStationsGlobalIndexState", type="String", defaultValue="BDescriptorState.idle.getDisplayTag(null)", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")})
public final class BReachableStationsSystemIndexMonitor
extends BComponent
implements BIMixIn,
BIRestrictedComponent,
ICoalesceable,
Runnable {
    @Generated
    public static final Property reachableStationsGlobalIndexState = BReachableStationsSystemIndexMonitor.newProperty((int)3, (String)BDescriptorState.idle.getDisplayTag(null), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BReachableStationsSystemIndexMonitor.class);
    private static final Logger LOG = Logger.getLogger("systemIndex");
    private static final Lexicon LEXICON = Lexicon.make((String)"niagaraSystemIndex");
    private static final int UPDATE_RETRY_COUNT = 2;

    @Generated
    public String getReachableStationsGlobalIndexState() {
        return this.getString(reachableStationsGlobalIndexState);
    }

    @Generated
    public void setReachableStationsGlobalIndexState(String v) {
        this.setString(reachableStationsGlobalIndexState, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void asyncUpdate() {
        if (this.isRunning()) {
            UpdateWorker.WORK_QUEUE.enqueue((Object)this);
        }
    }

    public void started() {
        if (Sys.isStationStarted()) {
            this.asyncUpdate();
        }
    }

    public void stationStarted() {
        this.asyncUpdate();
    }

    @Override
    public void run() {
        if (!this.isRunning()) {
            return;
        }
        for (int i = 0; i <= 2; ++i) {
            try {
                ComponentTreeCursor cursor = new ComponentTreeCursor(this.getParent().asComponent(), BReachableStationSystemIndexDeviceExt.TYPE, null);
                int pendingCount = 0;
                int inProgressCount = 0;
                int idleCount = 0;
                int faultCount = 0;
                int successCount = 0;
                int ineligibleCount = 0;
                int unusedCount = 0;
                while (cursor.next(BReachableStationSystemIndexDeviceExt.class)) {
                    BReachableStationSystemIndexDeviceExt deviceExt = (BReachableStationSystemIndexDeviceExt)cursor.get();
                    if (!deviceExt.isRunning()) continue;
                    BDescriptorState state = deviceExt.getGlobalIndexState();
                    if (BDescriptorState.pending.equals((Object)state)) {
                        ++pendingCount;
                        continue;
                    }
                    if (BDescriptorState.inProgress.equals((Object)state)) {
                        ++inProgressCount;
                        continue;
                    }
                    if (deviceExt.isDisabled() || !deviceExt.canAcceptGlobalQueries(SystemIndexLog.DEFAULT_SYSTEM_INDEX_LOG, false, null)) {
                        ++ineligibleCount;
                        continue;
                    }
                    if (!deviceExt.getUsedByLastGlobalIndexAttempt()) {
                        ++unusedCount;
                        continue;
                    }
                    if (deviceExt.isFault()) {
                        ++faultCount;
                        continue;
                    }
                    if (!deviceExt.getGlobalIndexLastSuccess().isNull()) {
                        ++successCount;
                        continue;
                    }
                    ++idleCount;
                }
                this.setReachableStationsGlobalIndexState(LEXICON.getText("niagaraSystemIndex.reachableStationsIndexState", new Object[]{pendingCount, inProgressCount, successCount, faultCount, unusedCount, ineligibleCount, idleCount}));
                return;
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "Unexpected exception processing reachable station monitor update for " + this.toPathString(), e);
                }
                if (i >= 2) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.globalMonitor");
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BReachableStations.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(BReachableStationsSystemIndexMonitor.class)) {
            if (slots.get() == this) continue;
            throw new IllegalChildException("baja", "IllegalExtraRestrictedComponent", new Object[]{this.getType(), parent.getType()});
        }
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }

    private static final class UpdateWorker {
        public static final Queue WORK_QUEUE = new CoalesceQueue();
        private static final Worker WORKER = new Worker((Worker.ITodo)WORK_QUEUE);

        private UpdateWorker() {
        }

        static {
            WORKER.start("ReachableStationsSystemIndexMonitor");
        }
    }
}

