/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.fox.sys.data.EntityExportConsumer;
import com.tridium.fox.sys.data.EntityExportSource;
import com.tridium.nd.BNiagaraStation;
import com.tridium.niagaraSystemIndex.BAbstractSystemIndexDeviceExt;
import com.tridium.niagaraSystemIndex.BNiagaraNetworkSystemIndexer;
import com.tridium.niagaraSystemIndex.BNiagaraSystemIndexExport;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.systemIndex.BSystemIndexService;
import com.tridium.systemIndex.BSystemIndexer;
import com.tridium.systemIndex.SystemIndexLog;
import com.tridium.systemIndex.SystemIndexUtil;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BModule;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraStation"})})
@NiagaraProperties(value={@NiagaraProperty(name="receiveExportedIndexLastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="receiveExportedIndexLastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="receiveExportedIndexLastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="receiveExportedIndexFaultCause", type="String", defaultValue="", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="receiveExportedIndexFromRemoteStation", type="boolean", defaultValue="false")})
public final class BNiagaraSystemIndexDeviceExt
extends BAbstractSystemIndexDeviceExt
implements BIMixIn,
BIRestrictedComponent,
EntityExportConsumer,
EntityExportSource {
    @Generated
    public static final Property receiveExportedIndexLastAttempt = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property receiveExportedIndexLastSuccess = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property receiveExportedIndexLastFailure = BNiagaraSystemIndexDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property receiveExportedIndexFaultCause = BNiagaraSystemIndexDeviceExt.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property receiveExportedIndexFromRemoteStation = BNiagaraSystemIndexDeviceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraSystemIndexDeviceExt.class);
    private long numExportExecutes;
    private long totalExportExecuteTime;
    private long minExportExecuteTime = Long.MAX_VALUE;
    private long maxExportExecuteTime;

    @Generated
    public BAbsTime getReceiveExportedIndexLastAttempt() {
        return (BAbsTime)this.get(receiveExportedIndexLastAttempt);
    }

    @Generated
    public void setReceiveExportedIndexLastAttempt(BAbsTime v) {
        this.set(receiveExportedIndexLastAttempt, (BValue)v, null);
    }

    @Generated
    public BAbsTime getReceiveExportedIndexLastSuccess() {
        return (BAbsTime)this.get(receiveExportedIndexLastSuccess);
    }

    @Generated
    public void setReceiveExportedIndexLastSuccess(BAbsTime v) {
        this.set(receiveExportedIndexLastSuccess, (BValue)v, null);
    }

    @Generated
    public BAbsTime getReceiveExportedIndexLastFailure() {
        return (BAbsTime)this.get(receiveExportedIndexLastFailure);
    }

    @Generated
    public void setReceiveExportedIndexLastFailure(BAbsTime v) {
        this.set(receiveExportedIndexLastFailure, (BValue)v, null);
    }

    @Generated
    public String getReceiveExportedIndexFaultCause() {
        return this.getString(receiveExportedIndexFaultCause);
    }

    @Generated
    public void setReceiveExportedIndexFaultCause(String v) {
        this.setString(receiveExportedIndexFaultCause, v, null);
    }

    @Override
    @Generated
    public boolean getReceiveExportedIndexFromRemoteStation() {
        return this.getBoolean(receiveExportedIndexFromRemoteStation);
    }

    @Generated
    public void setReceiveExportedIndexFromRemoteStation(boolean v) {
        this.setBoolean(receiveExportedIndexFromRemoteStation, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean canAcceptEntitiesFromRemoteExport(Context cx) {
        boolean result;
        BSystemIndexService indexService = BNiagaraSystemIndexDeviceExt.getSystemIndexService(false);
        boolean bl = result = this.getReceiveExportedIndexFromRemoteStation() && indexService != null && indexService.isOperational() && !this.getDevice().isDisabled() && !this.getDevice().isFatalFault();
        if (result) {
            try {
                this.checkLicenseForIndexing();
            }
            catch (Exception e) {
                this.setReceiveExportedIndexLastAttempt(Clock.time());
                this.setReceiveExportedIndexLastFailure(Clock.time());
                this.setReceiveExportedIndexFaultCause(SystemIndexUtil.getFailureReason((Throwable)e));
                return false;
            }
        }
        return result;
    }

    public void consumeEntitiesFromRemoteExport(List<Entity> entities, Context cx) {
        if (!this.canAcceptEntitiesFromRemoteExport(cx)) {
            return;
        }
        BNiagaraNetworkSystemIndexer.executeAsync((BSystemIndexService)Sys.getService((Type)BSystemIndexService.TYPE), null, () -> {
            long startTicks = Clock.ticks();
            this.setReceiveExportedIndexLastAttempt(Clock.time());
            this.setReceiveExportedIndexFaultCause("");
            try {
                BSystemIndexer.runIndex((String)Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.indexExport.server", new Object[]{this.getDevice().getName()}), (Context)cx, (log, context) -> {
                    long start = DiagnosticUtil.startIfLoggable((String)"systemIndexDeviceExt_exportReceived");
                    try {
                        int limit;
                        if (log.isLoggingEnabled()) {
                            log.start("niagaraSystemIndex", "niagaraSystemIndex.receiveIndexExport.start", new String[]{'\"' + this.getDevice().getName() + '\"'});
                        }
                        int size = (limit = this.checkLicenseForIndexing()) != Integer.MAX_VALUE ? entities.size() : -1;
                        String stationNameStr = ((BINiagaraStation)this.getDevice()).getStationName();
                        BSystemIndexer.systemIndexToSystemDb((String)stationNameStr, BNiagaraSystemIndexDeviceExt.toEntityStream(stationNameStr, entities, size, limit, null), (SystemIndexLog)log, (Context)BAbstractSystemIndexDeviceExt.SystemIndexContextHolder.INDEX_CONTEXT);
                        if (size > limit) {
                            String[] args = new String[]{stationNameStr, Integer.toString(size), Integer.toString(limit)};
                            this.setReceiveExportedIndexFaultCause(Lexicon.make((String)"systemIndex").getText("systemIndex.exceededEntityLimit", (Object[])args));
                            if (log.isLoggingEnabled()) {
                                log.message("systemIndex", "systemIndex.exceededEntityLimit.noLineFeeds", args);
                            }
                        }
                        this.setReceiveExportedIndexLastSuccess(Clock.time());
                        if (log.isLoggingEnabled()) {
                            log.success("niagaraSystemIndex", "niagaraSystemIndex.receiveIndexExport.complete", '\"' + this.getDevice().getName() + '\"');
                        }
                    }
                    catch (Exception e) {
                        if (log.isLoggingEnabled()) {
                            log.failed("niagaraSystemIndex", "niagaraSystemIndex.receiveIndexExport.failed", '\"' + this.getDevice().getName() + '\"', (Throwable)e);
                        }
                        throw BSystemIndexer.convertIndexException((Exception)e);
                    }
                    finally {
                        if (start != 0L) {
                            DiagnosticUtil.complete((long)start, (String)"systemIndexDeviceExt_exportReceived", (Object)this.toDisplayPathString(cx));
                        }
                    }
                });
            }
            catch (Exception e) {
                this.setReceiveExportedIndexLastFailure(Clock.time());
                this.setReceiveExportedIndexFaultCause(SystemIndexUtil.getFailureReason((Throwable)e));
                throw e;
            }
            finally {
                this.updateExportStatistics(startTicks);
            }
        });
    }

    public boolean isEntityExportEnabled() {
        SlotCursor c = this.getProperties();
        while (c.next(BNiagaraSystemIndexExport.class)) {
            BNiagaraSystemIndexExport export = (BNiagaraSystemIndexExport)c.get();
            if (export.isDisabled() || export.isFatalFault()) continue;
            return true;
        }
        return false;
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.deviceExt");
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BNiagaraStation.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(BNiagaraSystemIndexDeviceExt.class)) {
            if (slots.get() == this) continue;
            throw new IllegalChildException("niagaraSystemIndex", "niagaraSystemIndex.duplicateStationIndexer", new Object[]{this.getType()});
        }
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"NiagaraSystemIndexDeviceExt Statistics", 2);
            out.prop((Object)"Total Incoming Index Export attempts", (Object)String.valueOf(this.numExportExecutes));
            out.prop((Object)"Total Incoming Index Export time", (Object)BRelTime.make((long)this.totalExportExecuteTime));
            long avg = this.numExportExecutes > 0L ? this.totalExportExecuteTime / this.numExportExecutes : 0L;
            out.prop((Object)"Avg Incoming Index Export time", (Object)BRelTime.make((long)avg));
            long min = this.minExportExecuteTime != Long.MAX_VALUE ? this.minExportExecuteTime : 0L;
            out.prop((Object)"Min Incoming Index Export time", (Object)BRelTime.make((long)min));
            out.prop((Object)"Max Incoming Index Export time", (Object)BRelTime.make((long)this.maxExportExecuteTime));
            out.endProps();
        }
        super.spy(out);
    }

    private void updateExportStatistics(long startTicks) {
        long duration = Clock.ticks() - startTicks;
        ++this.numExportExecutes;
        this.totalExportExecuteTime += duration;
        if (duration <= this.minExportExecuteTime) {
            this.minExportExecuteTime = duration;
        }
        if (duration >= this.maxExportExecuteTime) {
            this.maxExportExecuteTime = duration;
        }
    }
}

