/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platNrio;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platNrio.BNrioPlatformService;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="openTest"), @NiagaraAction(name="configTest"), @NiagaraAction(name="discoverTest"), @NiagaraAction(name="setLogicalAddressTest", parameterType="BInteger", defaultValue="BInteger.make(1)"), @NiagaraAction(name="pingTest"), @NiagaraAction(name="enablePollingTest", parameterType="BInteger", defaultValue="BInteger.make(1)"), @NiagaraAction(name="disablePollingTest", parameterType="BInteger", defaultValue="BInteger.make(1)"), @NiagaraAction(name="waitForStatusChangeTest")})
public class BNrioPlatformServiceQnx
extends BNrioPlatformService {
    @Generated
    public static final Action openTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    @Generated
    public static final Action configTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    @Generated
    public static final Action discoverTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    @Generated
    public static final Action setLogicalAddressTest = BNrioPlatformServiceQnx.newAction((int)0, (BValue)BInteger.make((int)1), null);
    @Generated
    public static final Action pingTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    @Generated
    public static final Action enablePollingTest = BNrioPlatformServiceQnx.newAction((int)0, (BValue)BInteger.make((int)1), null);
    @Generated
    public static final Action disablePollingTest = BNrioPlatformServiceQnx.newAction((int)0, (BValue)BInteger.make((int)1), null);
    @Generated
    public static final Action waitForStatusChangeTest = BNrioPlatformServiceQnx.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNrioPlatformServiceQnx.class);
    private boolean nativesLoaded = false;
    private Process actrld;
    int testHandle = -1;
    byte[] moduleUID = new byte[6];
    byte type;

    @Generated
    public void openTest() {
        this.invoke(openTest, null, null);
    }

    @Generated
    public void configTest() {
        this.invoke(configTest, null, null);
    }

    @Generated
    public void discoverTest() {
        this.invoke(discoverTest, null, null);
    }

    @Generated
    public void setLogicalAddressTest(BInteger parameter) {
        this.invoke(setLogicalAddressTest, (BValue)parameter, null);
    }

    @Generated
    public void pingTest() {
        this.invoke(pingTest, null, null);
    }

    @Generated
    public void enablePollingTest(BInteger parameter) {
        this.invoke(enablePollingTest, (BValue)parameter, null);
    }

    @Generated
    public void disablePollingTest(BInteger parameter) {
        this.invoke(disablePollingTest, (BValue)parameter, null);
    }

    @Generated
    public void waitForStatusChangeTest() {
        this.invoke(waitForStatusChangeTest, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading platnrio native library");
                System.loadLibrary("platnrio");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load platnrio native library", e);
            }
            return this.nativesLoaded;
        });
    }

    public void serviceStarted() throws Exception {
        try {
            AccessController.doPrivileged(() -> {
                File f = new File("/dev/actrl1");
                if (f.exists()) {
                    log.info("access/nrio daemon already running");
                } else {
                    int numTrunks = 2;
                    this.actrld = new ProcessBuilder("/proc/boot/actrld", "-n", String.valueOf(numTrunks)).start();
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        super.serviceStarted();
    }

    public void serviceStopped() throws Exception {
        if (this.actrld != null) {
            this.actrld.destroy();
            this.actrld = null;
        }
        super.serviceStopped();
    }

    @Override
    public int open(int trunk) {
        log.fine("open()");
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load nrio natives");
        }
        int fd = this.open0(trunk);
        log.fine("opened, fd = " + fd);
        return fd;
    }

    @Override
    public void close(int handle) {
        log.fine("close()");
        this.close0(handle);
    }

    @Override
    public void setPortParams(int handle, String comPort, int baudrate) {
        log.fine("setPortParams " + comPort + " baudrate " + baudrate);
        this.setPortParams0(handle, comPort, baudrate);
    }

    @Override
    public Vector<byte[]> discover(int handle) {
        log.fine("discover entry");
        Vector<byte[]> v = new Vector<byte[]>(16);
        this.discover0(handle, v);
        log.fine("discover returned " + v.size());
        return v;
    }

    @Override
    public void enablePolling(int handle, int addr) {
        log.fine("enable polling " + addr);
        this.enablePolling0(handle, addr);
    }

    @Override
    public void disablePolling(int handle, int addr) {
        log.fine("disable polling " + addr);
        this.disablePolling0(handle, addr);
    }

    @Override
    public void waitForStatusChange(int handle, byte[] reply) {
        log.fine("waitForStatusChange entry");
        if (reply.length < 128) {
            throw new IllegalArgumentException("Reply buffer too small");
        }
        this.waitForStatusChange0(handle, reply);
        log.fine("waitForStatusChange exit");
    }

    @Override
    public void sendRequest(int handle, byte[] request, byte[] reply) {
        log.fine("sendRequest entry");
        if (reply.length < 128) {
            throw new IllegalArgumentException("Reply buffer too small");
        }
        this.sendRequest0(handle, request, reply);
        log.fine("sendRequest0 exit");
    }

    @Override
    public BufferedReader readStats(int handle, int trunk) {
        try {
            return AccessController.doPrivileged(() -> {
                Process process = new ProcessBuilder("/proc/boot/cat", "/dev/actrl" + trunk).start();
                try {
                    return new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Could not get input stream for readStats()", e);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            log.log(Level.SEVERE, "Error while creating process needed for readStats()", pae);
            return null;
        }
    }

    native int open0(int var1);

    native void close0(int var1);

    native void setPortParams0(int var1, String var2, int var3);

    native void discover0(int var1, Vector<byte[]> var2);

    native void enablePolling0(int var1, int var2);

    native void disablePolling0(int var1, int var2);

    native void waitForStatusChange0(int var1, byte[] var2);

    native void sendRequest0(int var1, byte[] var2, byte[] var3);

    public void doOpenTest() {
        this.testHandle = this.open(1);
    }

    public void doConfigTest() {
        this.setPortParams(this.testHandle, "/dev/ser2", 115200);
    }

    public void doDiscoverTest() {
        Vector<byte[]> v = this.discover(this.testHandle);
        Enumeration<byte[]> e = v.elements();
        while (e.hasMoreElements()) {
            byte[] msg = e.nextElement();
            System.out.println("Discover response: ");
            ByteArrayUtil.hexDump((byte[])msg, (int)0, (int)msg.length);
            System.arraycopy(msg, 4, this.moduleUID, 0, 6);
            this.type = msg[10];
        }
    }

    public void doSetLogicalAddressTest(BInteger addr) {
        byte[] request = new byte[11];
        byte[] reply = new byte[128];
        request[0] = -68;
        request[1] = 9;
        request[2] = 2;
        request[3] = 0;
        System.arraycopy(this.moduleUID, 0, request, 4, 6);
        request[10] = (byte)addr.getInt();
        System.out.println("Set Logical Address request: ");
        ByteArrayUtil.hexDump((byte[])request, (int)0, (int)request.length);
        this.sendRequest(this.testHandle, request, reply);
        System.out.println("Set Logical Address reply: ");
        ByteArrayUtil.hexDump((byte[])reply, (int)0, (int)reply.length);
    }

    public void doPingTest() {
        byte[] request = new byte[11];
        byte[] reply = new byte[128];
        request[0] = -68;
        request[1] = 9;
        request[2] = 3;
        request[3] = 0;
        System.arraycopy(this.moduleUID, 0, request, 4, 6);
        request[10] = this.type;
        System.out.println("Ping request: ");
        ByteArrayUtil.hexDump((byte[])request, (int)0, (int)request.length);
        this.sendRequest(this.testHandle, request, reply);
        System.out.println("Ping reply: ");
        ByteArrayUtil.hexDump((byte[])reply, (int)0, (int)reply.length);
    }

    public void doEnablePollingTest(BInteger addr) {
        this.enablePolling(this.testHandle, addr.getInt());
    }

    public void doDisablePollingTest(BInteger addr) {
        this.disablePolling(this.testHandle, addr.getInt());
    }

    public void doWaitForStatusChangeTest() {
        byte[] reply = new byte[128];
        this.waitForStatusChange(this.testHandle, reply);
        System.out.println("Wait for status change reply: ");
        ByteArrayUtil.hexDump((byte[])reply, (int)0, (int)reply.length);
    }
}

