/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.enums.BAceCompQueryTypeEnum;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.message.AceComponentQuery;
import com.tridium.ace.message.AceComponentQueryResp;
import com.tridium.ace.message.AceError;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.point.BasePointGatherer;
import com.tridium.ace.point.ComponentCollector;
import com.tridium.ace.point.ICommStandIn;
import com.tridium.ndriver.datatypes.BAddress;
import javax.baja.sys.BajaException;

public class OnlinePointGatherer
extends BasePointGatherer {
    private final ICommStandIn comm;
    private final BAddress deviceAddress;

    public OnlinePointGatherer(ICommStandIn comm, BAddress deviceAddress, Catalog catalog) {
        super(catalog);
        this.comm = comm;
        this.deviceAddress = deviceAddress;
    }

    @Override
    public void gatherAllAppComponents(ComponentCollector collector) throws Exception {
        this.gatherChildAppComponents(collector, 0);
    }

    private void gatherChildAppComponents(ComponentCollector collector, int parentId) throws Exception {
        int[] childIds;
        for (int childId : childIds = this.loadChildIds(parentId)) {
            String typeName = this.loadComponentTypeName(childId);
            String fullName = this.loadAppComponentFullName(childId);
            collector.foundAppComponentId(childId);
            collector.foundAppComponentTypeName(childId, typeName);
            collector.foundAppComponentFullName(childId, fullName);
            if (!collector.hasKitComponent(typeName)) {
                this.gatherKitComponentPoints(collector, typeName);
            }
            this.gatherChildAppComponents(collector, childId);
        }
    }

    private String loadAppComponentFullName(int appComponentId) throws Exception {
        AceComponentQueryResp queryResp = this.sendQuery(appComponentId, BAceCompQueryTypeEnum.fullName);
        String fullName = queryResp.getFullName();
        if (fullName.substring(0, 4).compareToIgnoreCase("app.") == 0) {
            fullName = fullName.substring(4);
        }
        return fullName;
    }

    private String loadComponentTypeName(int appComponentId) throws Exception {
        AceComponentQueryResp queryResp = this.sendQuery(appComponentId, BAceCompQueryTypeEnum.compType);
        return queryResp.getCompType();
    }

    private int[] loadChildIds(int parentId) throws Exception {
        AceComponentQueryResp queryResp = this.sendQuery(parentId, BAceCompQueryTypeEnum.children);
        return queryResp.getChildren();
    }

    private AceComponentQueryResp sendQuery(int appComponentId, BAceCompQueryTypeEnum action) throws Exception {
        AceComponentQuery queryReq = AceComponentQuery.make(appComponentId, action);
        queryReq.setAddress(this.deviceAddress);
        AceMessage resp = (AceMessage)this.comm.sendRequest(queryReq);
        if (resp.isError()) {
            throw new BajaException(((AceError)resp).toExceptionMessage());
        }
        return (AceComponentQueryResp)resp;
    }
}

