/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.enums.BAceSlotTypeEnum;
import com.tridium.ace.point.KitPointDefinition;
import com.tridium.ace.point.PointDefinition;
import java.util.Iterator;
import java.util.TreeMap;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;

public class KitComponentPoints
extends TreeMap<Integer, PointDefinition> {
    private final String typeName;

    public KitComponentPoints(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean hasSolitaryPoint() {
        return this.size() == 1;
    }

    public void setPoint(int slotId, String slotName, BAceSlotTypeEnum slotType, boolean config, BAcePrimitiveTypeEnum dataType, BFacets facets, BValue defaultValue) {
        this.getPoint(slotId).set(slotName, slotType, config, dataType, facets, defaultValue);
    }

    public KitPointDefinition getPoint(String slotName) {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            KitPointDefinition kd = (KitPointDefinition)it.next().getValue();
            if (!kd.getSlotName().equals(slotName)) continue;
            return kd;
        }
        return null;
    }

    private KitPointDefinition getPoint(int slotId) {
        KitPointDefinition point = (KitPointDefinition)this.get(slotId);
        if (point == null) {
            point = new KitPointDefinition(this, slotId);
            this.put(slotId, point);
        }
        return point;
    }
}

