/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.point;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.point.BAcePointDiscoveryLeaf;
import com.tridium.ace.point.BAcePointDiscoveryPreferences;
import com.tridium.ace.point.BAcePointFolder;
import com.tridium.ace.point.BAceProxyExt;
import com.tridium.ace.point.PointDescriptions;
import com.tridium.ace.point.PointDescriptor;
import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryGroup;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.point.BNPointDeviceExt;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.Objects;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BPointFolder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="discoveryPreferences", type="BNDiscoveryPreferences", defaultValue="new BAcePointDiscoveryPreferences()", flags=5, override=true)
@NiagaraAction(name="forceUpdate", flags=4)
@NiagaraTopic(name="missingModules", eventType="BString", flags=8)
public class BAcePointDeviceExt
extends BNPointDeviceExt {
    @Generated
    public static final Property discoveryPreferences = BAcePointDeviceExt.newProperty((int)5, (BValue)new BAcePointDiscoveryPreferences(), null);
    @Generated
    public static final Action forceUpdate = BAcePointDeviceExt.newAction((int)4, null);
    @Generated
    public static final Topic missingModules = BAcePointDeviceExt.newTopic((int)8, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAcePointDeviceExt.class);
    boolean proxyTabInited = false;
    IntHashMap proxyTab = new IntHashMap();
    String unloadedModules = null;

    @Generated
    public void forceUpdate() {
        this.invoke(forceUpdate, null, null);
    }

    @Generated
    public void fireMissingModules(BString event) {
        this.fire(missingModules, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (oldValue instanceof BAcePointFolder || oldValue instanceof BControlPoint) {
            this.proxyChanged();
            this.relinquishProxyValues((BAceProxyExt[])CompUtil.getDescendants((BComponent)oldValue.asComponent(), BAceProxyExt.class));
        }
    }

    public void relinquishProxyValues(BAceProxyExt[] proxyExts) {
        for (BAceProxyExt proxyExt : proxyExts) {
            BAcePrimitive relinquishValue;
            if (!proxyExt.getMode().isWrite() || !(relinquishValue = proxyExt.getRelinquishValue()).isStatus()) continue;
            this.getAceDevice().getWriteWorker().write(proxyExt.getCompId(), proxyExt.getPropId(), relinquishValue, null);
        }
    }

    public boolean isChildLegal(BComponent child) {
        return BAcePointDeviceExt.isPointChildLegal(child);
    }

    public static boolean isPointChildLegal(BComponent child) {
        return !child.getType().is(BPointFolder.TYPE) || child.getType().is(BAcePointFolder.TYPE);
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (context == Context.decoding) {
            return;
        }
        if (!(value instanceof BControlPoint)) {
            return;
        }
        BAbstractProxyExt aext = ((BControlPoint)value).getProxyExt();
        if (!(aext instanceof BAceProxyExt)) {
            return;
        }
        BAceProxyExt ext = (BAceProxyExt)aext;
        if (this.getProxyExt(ext.getCompId(), ext.getPropId()) != null) {
            throw new LocalizableRuntimeException("ace", "ace.duplicateProxy");
        }
    }

    public final BAceNetwork getAceNetwork() {
        return (BAceNetwork)this.getNetwork();
    }

    public final BAceDevice getAceDevice() {
        return (BAceDevice)this.getDevice();
    }

    public Type getDeviceType() {
        return BAceDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BAcePointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BAceProxyExt.TYPE;
    }

    public void reassertProxyCov() {
        this.initPropIdTable();
        for (BAceProxyExt proxyExt : this.proxyTab) {
            proxyExt.reassertCov();
        }
    }

    public void reassertProxyCov(int compId) {
        this.initPropIdTable();
        for (BAceProxyExt proxyExt : this.proxyTab) {
            if (proxyExt.getCompId() != compId) continue;
            proxyExt.reassertCov();
        }
    }

    public void doForceUpdate() {
        this.getAceNetwork().postAsync(new Runnable(){

            @Override
            public void run() {
                BAcePointDeviceExt.this.implForceUpdate();
            }
        });
    }

    public void implForceUpdate() {
        this.initPropIdTable();
        for (BAceProxyExt proxyExt : this.proxyTab) {
            proxyExt.forceUpdate();
        }
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        boolean learnOffline = false;
        BAceDevice device = this.getAceDevice();
        this.unloadedModules = null;
        PointDescriptions pointDescriptions = device.loadPointDescriptionsOnline();
        ArrayList<Object> discoveryObjects = new ArrayList<Object>();
        BNDiscoveryGroup group = null;
        int counter = 0;
        for (PointDescriptor pointDescriptor : pointDescriptions) {
            if (pointDescriptor.getSlotType().isAction()) continue;
            BAcePointDiscoveryLeaf leaf = new BAcePointDiscoveryLeaf(pointDescriptor);
            String fullName = pointDescriptor.getAppComponentFullName();
            if (group != null && !Objects.equals(group.getDescription(), fullName)) {
                discoveryObjects.add(group);
                group = null;
            }
            if (pointDescriptor.isSolitary()) {
                discoveryObjects.add((Object)leaf);
                continue;
            }
            if (group == null) {
                group = new BNDiscoveryGroup();
                group.setDescription(fullName);
            }
            group.add("L" + counter++, (BValue)leaf, null);
        }
        if (group != null) {
            discoveryObjects.add(group);
        }
        if (this.unloadedModules != null) {
            this.fireMissingModules(BString.make((String)this.unloadedModules));
        }
        return discoveryObjects.toArray(new BINDiscoveryObject[0]);
    }

    public BAceProxyExt getProxyExt(int oid, int pid) {
        this.initPropIdTable();
        return (BAceProxyExt)((Object)this.proxyTab.get(this.makeHashCd(oid, pid)));
    }

    private void initPropIdTable() {
        BAceProxyExt[] prxyA;
        if (this.proxyTabInited) {
            return;
        }
        this.proxyTab.clear();
        for (BAceProxyExt p : prxyA = (BAceProxyExt[])CompUtil.getDescendants((BComponent)this, BAceProxyExt.class)) {
            this.proxyTab.put(this.makeHashCd(p.getCompId(), p.getPropId()), (Object)p);
        }
        this.proxyTabInited = true;
    }

    public void proxyChanged() {
        this.proxyTabInited = false;
    }

    private int makeHashCd(int oid, int pid) {
        return oid << 15 | pid;
    }

    public void setUnloadedModules(String val) {
        this.unloadedModules = val;
    }
}

