/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.message;

import com.tridium.ace.message.AceAck;
import com.tridium.ace.message.AceComponentQueryResp;
import com.tridium.ace.message.AceComponentReqResp;
import com.tridium.ace.message.AceConst;
import com.tridium.ace.message.AceCov;
import com.tridium.ace.message.AceDebug;
import com.tridium.ace.message.AceError;
import com.tridium.ace.message.AceFileReadResp;
import com.tridium.ace.message.AceFileTransferInitResp;
import com.tridium.ace.message.AceFileWriteResp;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.message.AceReadResponse;
import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.io.TypedInputStream;
import java.io.InputStream;

public class AceMessageFactory
implements IMessageFactory,
AceConst {
    public NMessage makeMessage(LinkMessage lm) throws Exception {
        TypedInputStream tin = new TypedInputStream(lm.getByteArray());
        tin.readUnsigned8();
        int type = tin.readUnsigned8();
        tin.reset();
        AceMessage msg = null;
        if ((type & 0x40) > 0) {
            msg = new AceError(type);
        } else if ((type & 0x80) > 0) {
            switch (type & 0x3F) {
                case 1: {
                    msg = new AceReadResponse();
                    break;
                }
                case 8: {
                    msg = new AceComponentReqResp();
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 9: {
                    msg = new AceAck();
                    break;
                }
                case 5: {
                    msg = new AceFileTransferInitResp();
                    break;
                }
                case 6: {
                    msg = new AceFileWriteResp();
                    break;
                }
                case 10: {
                    msg = new AceFileReadResp();
                    break;
                }
                case 11: {
                    msg = new AceComponentQueryResp();
                }
            }
        } else {
            switch (type & 0x3F) {
                case 4: {
                    msg = new AceCov();
                    break;
                }
                case 63: {
                    msg = new AceDebug();
                }
            }
        }
        if (msg == null) {
            System.out.println("Unsupported incoming message type " + Integer.toString(type, 16));
            return null;
        }
        if (msg != null) {
            msg.fromInputStream((InputStream)tin);
            msg.setAddress((BAddress)lm.address);
        }
        return msg;
    }
}

