/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.kit;

import com.tridium.ace.kit.AceType;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.Kit;
import com.tridium.ace.kit.TypeNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CatalogKit
implements Kit {
    private final String name;
    private final String displayName;
    private final Catalog catalog;
    private final long checksum;
    private final HashMap<String, Integer> typeIndices = new HashMap();
    private final List<AceType> types = new ArrayList<AceType>();

    private CatalogKit() {
        this.name = "";
        this.checksum = 0L;
        this.catalog = null;
        this.displayName = "";
    }

    public CatalogKit(String name, String displayName, long checksum, Catalog kitRegistry) {
        this.name = name;
        this.checksum = checksum;
        this.catalog = kitRegistry;
        this.displayName = displayName;
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Collection<AceType> types() {
        return this.types;
    }

    public AceType type(String name) {
        Integer index = this.typeIndices.get(name);
        if (index != null) {
            return this.types.get(this.typeIndices.get(name));
        }
        return null;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    public void add(AceType aceType) throws TypeNameException {
        if (this.typeIndices.get(aceType.getTypeName()) != null) {
            throw new TypeNameException("Duplicate type name: " + aceType.getTypeName());
        }
        this.typeIndices.put(aceType.getTypeName(), this.types.size());
        this.types.add(aceType);
    }

    public AceType lookupType(int typeIndex) {
        return this.types.get(typeIndex);
    }

    public int typeIndex(String typeName) {
        return this.typeIndices.get(typeName);
    }

    public String toString() {
        return this.name;
    }
}

