/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.json;

import com.tridium.ace.app.AceAppWriter;
import com.tridium.ace.app.AceLink;
import com.tridium.ace.component.AceUtil;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.component.BAceLink;
import com.tridium.ace.component.BAceTextBlock;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.datatypes.InvalidTypeException;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.kit.ACE;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.CatalogHeader;
import com.tridium.ace.sys.AceException;
import com.tridium.ace.sys.BAceApp;
import com.tridium.json.JSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.status.BIStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

public class JAppWriter
extends AceAppWriter {
    Set<AceLink> links;
    public static final Logger log = Logger.getLogger("sys.json");
    public static Lexicon lex = Lexicon.make((String)"ace");
    public static final String PRODUCT_NAME = "product";
    public static final String VENDOR_NAME = "vendor";

    @Override
    public void encode(OutputStream outputStream, BAceApp rootComp, Catalog catalog) throws IOException {
        OutputStreamWriter sw = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
        JSONWriter jw = new JSONWriter((Appendable)sw);
        jw.object();
        jw.key("version").value((Object)ACE.VERSION);
        jw.key("kits").array();
        HashSet kitNames = new HashSet();
        rootComp.forEachAceComponent(component -> kitNames.add(component.getAceKitName()));
        for (String kitName : kitNames) {
            jw.object();
            jw.key("name").value((Object)kitName);
            jw.key("checksum").value(catalog.get(kitName).getChecksum());
            jw.endObject();
        }
        jw.endArray();
        this.links = new HashSet<AceLink>();
        jw.key("comps").array();
        this.writeAceComponent(jw, rootComp);
        jw.endArray();
        jw.key("links").array();
        for (AceLink link : this.links) {
            jw.object();
            jw.key("from").value((Object)link.getFrom());
            jw.key("to").value((Object)link.getTo());
            jw.endObject();
        }
        jw.endArray();
        CatalogHeader header = catalog.getCatalogHeader();
        if (header != null) {
            jw.key(PRODUCT_NAME).value((Object)header.product);
            jw.key(VENDOR_NAME).value((Object)header.vendor);
        } else {
            log.warning(lex.getText("ace.noCatalogHeader"));
        }
        jw.endObject();
        sw.close();
    }

    private static String bytesToHex(byte[] hashInBytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : hashInBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private void writeAceComponent(JSONWriter jw, BAceComponent component) {
        Property[] props;
        jw.object();
        jw.key("name").value((Object)component.getAceComponentName());
        jw.key("id").value((long)component.getObjectId());
        jw.key("type");
        jw.object();
        jw.key("name").value((Object)component.getAceTypeName());
        jw.key("kitName").value((Object)component.getAceKitName());
        jw.endObject();
        jw.key("props").array();
        int meta = component.getMeta();
        BValue annotation = component.get("wsAnnotation");
        if (annotation != null && annotation.getType().is(BWsAnnotation.TYPE)) {
            if (component instanceof BAceTextBlock) {
                BWsAnnotation anno = (BWsAnnotation)annotation;
                annotation = BWsAnnotation.make((int)anno.p, (int)anno.q);
            }
            try {
                meta = AceUtil.encodeWsAnnotationToMeta(meta, (BWsAnnotation)annotation);
            }
            catch (AceException ne) {
                log.warning(lex.getText("json.appSaveAnnotationError", new Object[]{component.getName(), ne.getLocalizedMessage()}));
                throw ne;
            }
        }
        jw.object();
        jw.key("name").value((Object)"meta");
        jw.key("value").value((long)meta);
        jw.endObject();
        jw.object();
        jw.key("name").value((Object)"exeParam");
        jw.key("value").value((long)component.getExeParam().getValue());
        jw.endObject();
        for (Property property : props = component.getPropertiesArray()) {
            boolean isModInput;
            BFacets facets;
            if (property.getName().equals("meta") || property.getName().equals("exeParam") || (facets = property.getFacets()) == null || facets.geti("pId", -1) < 0) continue;
            BValue val = component.get(property.getName());
            boolean isConfig = facets.getb("config", false);
            boolean bl = isModInput = facets.getb("input", false) && !Flags.isLinkTarget((BComplex)component, (Slot)property);
            if (!isConfig && !isModInput) continue;
            jw.object();
            jw.key("name").value((Object)property.getName());
            jw.key("value");
            BString primType = (BString)facets.get("type");
            BAcePrimitiveTypeEnum primTypeEnum = BAcePrimitiveTypeEnum.fromJsonName(primType.getString());
            BAcePrimitive primitive = BAcePrimitive.make(primTypeEnum, val);
            try {
                if (primTypeEnum.isBool()) {
                    jw.value(primitive.getBoolean());
                } else if (primTypeEnum.isInt()) {
                    jw.value((long)primitive.getInt());
                } else if (primTypeEnum.isLong()) {
                    jw.value(primitive.getLong());
                } else if (primTypeEnum.isFloat()) {
                    jw.value(primitive.getDouble());
                } else if (primTypeEnum.isString()) {
                    jw.value((Object)primitive.getString());
                } else if (primTypeEnum.isByteArray()) {
                    jw.value((Object)JAppWriter.bytesToHex(primitive.getByteArray()));
                } else {
                    jw.value((Object)property.getDefaultValue());
                }
                if (primTypeEnum.isStatus()) {
                    int status = val instanceof BIStatusValue ? ((BIStatusValue)val).getStatus().getBits() : 64;
                    jw.key("status").value((long)status);
                }
            }
            catch (InvalidTypeException e) {
                jw.value((Object)property.getDefaultValue());
            }
            jw.endObject();
        }
        jw.endArray();
        jw.key("children").array();
        for (Property property : component.getChildComponents()) {
            if (!(property instanceof BAceComponent)) continue;
            this.writeAceComponent(jw, (BAceComponent)property);
        }
        jw.endArray();
        for (Property property : component.getLinks()) {
            if (!property.getType().is(BAceLink.TYPE)) continue;
            if (!property.isActive()) {
                property.activate();
            }
            BAceComponent source = (BAceComponent)property.getSourceComponent();
            BAceComponent target = (BAceComponent)property.getTargetComponent();
            AceLink aceLink = new AceLink(source.getObjectId() + "." + property.getSourceSlotName(), target.getObjectId() + "." + property.getTargetSlotName());
            this.links.add(aceLink);
        }
        jw.endObject();
    }
}

