/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.datatypes;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.message.AceError;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.message.AceWrite;
import com.tridium.ace.message.ErrUtil;
import com.tridium.ace.point.BAceProxyExt;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.NMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;

@NiagaraType
public class BWriteWorker
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BWriteWorker.class);
    private static Logger RD_WR_LOG = BAceNetwork.RD_WR_LOG;
    CoalesceQueue coalesceQueue = new CoalesceQueue();
    boolean isAlive;
    Thread thread;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.thread = new Thread((Runnable)new Processor(), this.ace().getNetworkName() + ".write");
        this.thread.start();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.thread.interrupt();
    }

    public void write(BAceComponent cp, Property p, int propId) {
        if (!this.dev().isOperational() || !Sys.atSteadyState()) {
            return;
        }
        ObjectProp op = new ObjectProp(cp.getObjectId(), propId, cp.getPrimitive(p), null);
        this.coalesceQueue.enqueue((Object)op);
    }

    public void write(int compId, int propId, BAcePrimitive sv, BAceProxyExt pext) {
        if (!this.dev().isOperational() || !Sys.atSteadyState()) {
            return;
        }
        ObjectProp op = new ObjectProp(compId, propId, sv, pext);
        this.coalesceQueue.enqueue((Object)op);
    }

    public BAceNetwork ace() {
        return (BAceNetwork)DrUtil.getParent((BComplex)this, (Type)BAceNetwork.TYPE);
    }

    public BAceDevice dev() {
        return (BAceDevice)DrUtil.getParent((BComplex)this, (Type)BAceDevice.TYPE);
    }

    public static class ObjectProp
    implements ICoalesceable {
        int objId;
        int propId;
        BAcePrimitive primVal;
        BAceProxyExt proxyExt = null;

        ObjectProp(int oid, int pid, BAcePrimitive pv, BAceProxyExt pExt) {
            this.objId = oid;
            this.primVal = pv;
            this.propId = pid;
            this.proxyExt = pExt;
        }

        public Object getCoalesceKey() {
            return this.objId << 8 | this.propId;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }

        public String toString() {
            return this.objId + ":" + this.propId;
        }
    }

    class Processor
    implements Runnable {
        Processor() {
        }

        @Override
        public void run() {
            BWriteWorker.this.isAlive = true;
            BAceNetwork ace = BWriteWorker.this.ace();
            while (BWriteWorker.this.isAlive) {
                try {
                    ObjectProp op = (ObjectProp)BWriteWorker.this.coalesceQueue.dequeue(-1);
                    try {
                        AceWrite msg = AceWrite.make(op.objId, op.propId, op.primVal);
                        msg.setAddress(BWriteWorker.this.dev().getAddress());
                        if (RD_WR_LOG.isLoggable(Level.FINE)) {
                            RD_WR_LOG.fine("send:" + msg.toTraceString());
                        }
                        AceMessage resp = (AceMessage)ace.ncomm().sendRequest((NMessage)msg);
                        if (RD_WR_LOG.isLoggable(Level.FINE)) {
                            RD_WR_LOG.fine("rcv:" + resp.toTraceString());
                        }
                        if (op.proxyExt == null) continue;
                        if (resp.isError()) {
                            AceError err = (AceError)resp;
                            String errMsg = ErrUtil.errToString(err.err) + (err.errMsg.length() > 0 ? ":" + err.errMsg : "");
                            op.proxyExt.writeFail(errMsg);
                            continue;
                        }
                        op.proxyExt.writeOk(op.proxyExt.getWriteValue());
                    }
                    catch (Exception ce) {
                        if (op.proxyExt == null) continue;
                        op.proxyExt.writeFail("comm error");
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

