/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.datatypes;

import com.tridium.ace.datatypes.BIAceInteger;
import com.tridium.ace.datatypes.InvalidTypeException;
import com.tridium.ace.enums.BAcePrimitiveTypeEnum;
import com.tridium.ace.sys.AceException;
import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.ndriver.io.TypedInputStream;
import com.tridium.ndriver.io.TypedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BAcePrimitive
extends BSimple {
    public static final BAcePrimitive DEFAULT = new BAcePrimitive(BAcePrimitiveTypeEnum.DEFAULT, 0L);
    public static final Type TYPE = Sys.loadType(BAcePrimitive.class);
    public static Lexicon lex = Lexicon.make((String)"ace");
    protected static final Logger LOG = Logger.getLogger("AceNetwork");
    BAcePrimitiveTypeEnum primType;
    BStatus status = BStatus.DEFAULT;
    boolean bval;
    long ival;
    double fval;
    String sval;
    byte[] aval;

    public Type getType() {
        return TYPE;
    }

    private BAcePrimitive(BAcePrimitiveTypeEnum tp, boolean v) {
        this.primType = tp;
        this.bval = v;
    }

    private BAcePrimitive(BAcePrimitiveTypeEnum tp, long v) {
        this.primType = tp;
        this.ival = v;
    }

    private BAcePrimitive(BAcePrimitiveTypeEnum tp, double v) {
        this.primType = tp;
        this.fval = v;
    }

    private BAcePrimitive(BAcePrimitiveTypeEnum tp, String v) {
        this.primType = tp;
        this.sval = v;
    }

    private BAcePrimitive(BAcePrimitiveTypeEnum tp, byte[] v) {
        this.primType = tp;
        this.aval = v;
    }

    private BAcePrimitive(BAcePrimitiveTypeEnum tp, BStatus st, boolean v) {
        this.primType = tp;
        this.status = st;
        this.bval = v;
    }

    private BAcePrimitive(BAcePrimitiveTypeEnum tp, BStatus st, long v) {
        this.primType = tp;
        this.status = st;
        this.ival = v;
    }

    private BAcePrimitive(BAcePrimitiveTypeEnum tp, BStatus st, double v) {
        this.primType = tp;
        this.status = st;
        this.fval = v;
    }

    public static BAcePrimitive makeNull() {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.nullPrim, 0L);
    }

    public static BAcePrimitive makeBoolean(boolean v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.bool, v);
    }

    public static BAcePrimitive makeU8(int v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.u8, v);
    }

    public static BAcePrimitive makeU16(int v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.u16, v);
    }

    public static BAcePrimitive makeS32(int v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.s32, v);
    }

    public static BAcePrimitive makeS64(long v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.s64, v);
    }

    public static BAcePrimitive makeF32(float v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.f32, v);
    }

    public static BAcePrimitive makeF64(double v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.f64, v);
    }

    public static BAcePrimitive makeStatusBool(BStatusBoolean v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.statusBool, v.getStatus(), v.getValue());
    }

    public static BAcePrimitive makeStatusInt(BStatusNumeric v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.statusInt, v.getStatus(), (long)v.getValue());
    }

    public static BAcePrimitive makeStatusInt(BStatus s, long l) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.statusInt, s, l);
    }

    public static BAcePrimitive makeStatusFloat(BStatusNumeric v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.statusFloat, v.getStatus(), v.getValue());
    }

    public static BAcePrimitive makeStatusDouble(BStatusNumeric v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.statusDouble, v.getStatus(), v.getValue());
    }

    public static BAcePrimitive makeString(String v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.string, v);
    }

    public static BAcePrimitive makeByteArray(byte[] v) {
        return new BAcePrimitive(BAcePrimitiveTypeEnum.byteArray, v);
    }

    public boolean isNull() {
        return this.primType.isNull();
    }

    public boolean isBoolean() {
        return this.primType.isBool();
    }

    public boolean isInt() {
        return this.primType.isInt();
    }

    public boolean isLong() {
        return this.primType.isLong();
    }

    public boolean isFloat() {
        return this.primType.isFloat();
    }

    public boolean isByteArray() {
        return this.primType.isByteArray();
    }

    public boolean isStatus() {
        return this.primType.isStatus();
    }

    public boolean getBoolean() throws InvalidTypeException {
        if (!this.primType.isBool()) {
            throw new InvalidTypeException(lex.getText("ace.invalidTypeException", new Object[]{"boolean"}));
        }
        return this.bval;
    }

    public int getInt() throws InvalidTypeException {
        if (!this.primType.isInt()) {
            throw new InvalidTypeException(lex.getText("ace.invalidTypeException", new Object[]{"integer"}));
        }
        return (int)this.ival;
    }

    public long getLong() throws InvalidTypeException {
        if (!this.primType.isLong()) {
            throw new InvalidTypeException(lex.getText("ace.invalidTypeException", new Object[]{"long"}));
        }
        return this.ival;
    }

    public float getFloat() throws InvalidTypeException {
        if (!this.primType.isFloat()) {
            throw new InvalidTypeException(lex.getText("ace.invalidTypeException", new Object[]{"float"}));
        }
        return (float)this.fval;
    }

    public double getDouble() throws InvalidTypeException {
        if (!this.primType.isDouble()) {
            throw new InvalidTypeException(lex.getText("ace.invalidTypeException", new Object[]{"double"}));
        }
        return this.fval;
    }

    public String getString() throws InvalidTypeException {
        if (this.primType.isByteArray()) {
            return new String(this.aval, Charset.forName("UTF-8")).trim();
        }
        if (this.primType.isString()) {
            return this.sval;
        }
        throw new InvalidTypeException("Type is not string");
    }

    public byte[] getByteArray() throws InvalidTypeException {
        if (this.primType.isByteArray()) {
            return this.aval;
        }
        if (this.primType.isString()) {
            return this.sval.getBytes(Charset.forName("UTF-8"));
        }
        throw new InvalidTypeException(lex.getText("ace.invalidTypeException", new Object[]{"byte array"}));
    }

    public BStatus getStatus() {
        if (!this.primType.isStatus()) {
            return BStatus.ok;
        }
        return this.status;
    }

    public static BAcePrimitive make(BAcePrimitiveTypeEnum typ, BValue curVal) {
        boolean isStatusVal = curVal instanceof BStatusValue;
        boolean isEnum = curVal instanceof BStatusEnum || curVal instanceof BDynamicEnum;
        try {
            switch (typ.getOrdinal()) {
                case 0: {
                    return BAcePrimitive.makeNull();
                }
                case 1: {
                    return BAcePrimitive.makeBoolean(!isStatusVal ? ((BBoolean)curVal).getBoolean() : ((BStatusBoolean)curVal).getValue());
                }
                case 2: {
                    return BAcePrimitive.makeU8(BAcePrimitive.getInt(isStatusVal, isEnum, curVal));
                }
                case 3: {
                    return BAcePrimitive.makeU16(BAcePrimitive.getInt(isStatusVal, isEnum, curVal));
                }
                case 4: {
                    return BAcePrimitive.makeS32(BAcePrimitive.getInt(isStatusVal, isEnum, curVal));
                }
                case 5: {
                    return BAcePrimitive.makeS64(BAcePrimitive.getLong(isStatusVal, isEnum, curVal));
                }
                case 6: {
                    return BAcePrimitive.makeF32(!isStatusVal ? ((BFloat)curVal).getFloat() : (float)((BStatusNumeric)curVal).getValue());
                }
                case 7: {
                    return BAcePrimitive.makeF64(!isStatusVal ? ((BDouble)curVal).getDouble() : ((BStatusNumeric)curVal).getValue());
                }
                case 8: {
                    return BAcePrimitive.makeStatusBool((BStatusBoolean)curVal);
                }
                case 9: {
                    return BAcePrimitive.makeStatusInt(((BIStatusValue)curVal).getStatus(), BAcePrimitive.getLong(isStatusVal, isEnum, curVal));
                }
                case 10: {
                    return BAcePrimitive.makeStatusFloat((BStatusNumeric)curVal);
                }
                case 11: {
                    return BAcePrimitive.makeStatusDouble((BStatusNumeric)curVal);
                }
                case 13: {
                    if (curVal instanceof BEnumRange) {
                        return BAcePrimitive.makeString(((BEnumRange)curVal).encodeToString());
                    }
                    if (!isStatusVal) {
                        return BAcePrimitive.makeString(((BString)curVal).getString());
                    }
                    return BAcePrimitive.makeString(((BStatusString)curVal).getValue());
                }
                case 12: {
                    if (curVal instanceof BStatusString) {
                        return BAcePrimitive.makeByteArray(((BStatusString)curVal).getValue().getBytes(Charset.forName("UTF-8")));
                    }
                    if (curVal instanceof BString) {
                        return BAcePrimitive.makeByteArray(((BString)curVal).getString().getBytes(Charset.forName("UTF-8")));
                    }
                    return BAcePrimitive.makeByteArray(((BBlob)curVal).copyBytes());
                }
            }
            LOG.warning(lex.getText("ace.slotTypeError", new Object[]{typ}));
            throw new AceException("Invalid slot type");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int getInt(boolean isStatusVal, boolean isEnum, BValue curVal) {
        if (curVal instanceof BIAceInteger) {
            return ((BIAceInteger)curVal).getValue();
        }
        if (isEnum) {
            return ((BIEnum)curVal).getEnum().getOrdinal();
        }
        if (isStatusVal) {
            return (int)((BStatusNumeric)curVal).getValue();
        }
        return ((BInteger)curVal).getInt();
    }

    private static long getLong(boolean isStatusVal, boolean isEnum, BValue curVal) {
        if (isEnum) {
            return ((BIEnum)curVal).getEnum().getOrdinal();
        }
        if (isStatusVal) {
            return (long)((BStatusNumeric)curVal).getValue();
        }
        return ((BLong)curVal).getLong();
    }

    public void toOutputStream(TypedOutputStream out) {
        int ptyp = this.primType.getOrdinal();
        out.writeUnsigned8(ptyp == 13 ? 12 : ptyp);
        if (BAcePrimitiveTypeEnum.isStatusOrd(ptyp)) {
            out.writeUnsigned8(this.status.getBits());
        }
        switch (ptyp) {
            case 0: {
                break;
            }
            case 1: 
            case 8: {
                out.writeUnsigned8(this.bval ? 1 : 0);
                break;
            }
            case 2: {
                out.writeUnsigned8((int)this.ival);
                break;
            }
            case 3: {
                out.writeUnsigned16((int)this.ival);
                break;
            }
            case 4: 
            case 9: {
                out.writeSigned32((int)this.ival);
                break;
            }
            case 5: {
                out.writeSigned64(this.ival);
                break;
            }
            case 6: 
            case 10: {
                out.writeFloat((float)this.fval);
                break;
            }
            case 7: 
            case 11: {
                out.writeDouble(this.fval);
                break;
            }
            case 13: {
                int len = this.sval.length();
                out.writeUnsigned16(len + 1);
                out.writeString(this.sval);
                break;
            }
            case 12: {
                int len = this.aval.length;
                out.writeUnsigned16(len);
                out.writeByteArray(this.aval, len);
                break;
            }
            default: {
                throw new BajaRuntimeException("BAcePrimitive.toOutputStream() >> unsupported primitive type");
            }
        }
    }

    public static BAcePrimitive fromInputStream(TypedInputStream in) {
        int ptyp = in.readUnsigned8();
        int len = 0;
        BAcePrimitiveTypeEnum pType = (BAcePrimitiveTypeEnum)BAcePrimitiveTypeEnum.DEFAULT.getRange().get(ptyp);
        BStatus bStatus = null;
        if (BAcePrimitiveTypeEnum.isStatusOrd(ptyp)) {
            bStatus = BStatus.make((int)in.readUnsigned8());
        }
        switch (ptyp) {
            case 0: {
                return new BAcePrimitive(pType, 0L);
            }
            case 1: {
                return new BAcePrimitive(pType, in.readUnsigned8() != 0);
            }
            case 2: {
                return new BAcePrimitive(pType, in.readUnsigned8());
            }
            case 3: {
                return new BAcePrimitive(pType, in.readUnsigned16());
            }
            case 4: {
                return new BAcePrimitive(pType, in.readSigned32());
            }
            case 5: {
                return new BAcePrimitive(pType, in.readSigned64());
            }
            case 6: {
                return new BAcePrimitive(pType, in.readFloat());
            }
            case 7: {
                return new BAcePrimitive(pType, in.readDouble());
            }
            case 8: {
                return new BAcePrimitive(pType, bStatus, in.readUnsigned8() != 0);
            }
            case 9: {
                return new BAcePrimitive(pType, bStatus, in.readSigned32());
            }
            case 10: {
                return new BAcePrimitive(pType, bStatus, in.readFloat());
            }
            case 11: {
                return new BAcePrimitive(pType, bStatus, in.readDouble());
            }
            case 13: {
                len = in.readUnsigned16();
                return new BAcePrimitive(pType, in.readCharArray(len));
            }
            case 12: {
                len = in.readUnsigned16();
                return new BAcePrimitive(pType, in.readByteArray(len));
            }
        }
        throw new BajaRuntimeException("BAcePrimitive.fromInputStream() >> unsupported primitive type");
    }

    public int hashCode() {
        return this.toString(null).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BAcePrimitive)) {
            return false;
        }
        BAcePrimitive gv = (BAcePrimitive)((Object)obj);
        if (this.primType != gv.primType) {
            return false;
        }
        if (this.primType.isStatus()) {
            return this.status.equals((Object)gv.status);
        }
        if (this.primType.isString() && this.sval.equals(gv.sval)) {
            return false;
        }
        if (this.primType.isBool()) {
            if (this.bval != gv.bval) {
                return false;
            }
        } else {
            if (this.primType.isByteArray()) {
                return DrByteArrayUtil.equals((byte[])this.aval, (byte[])gv.aval);
            }
            if (this.primType.isFloat()) {
                return BDouble.equals((double)this.fval, (double)gv.fval);
            }
        }
        return this.ival == gv.ival;
    }

    public void encode(DataOutput encoder) throws IOException {
        this.primType.encode(encoder);
        this.status.encode(encoder);
        if (this.primType.isString()) {
            encoder.writeUTF(this.sval);
        }
        if (this.primType.isBool()) {
            encoder.writeBoolean(this.bval);
        } else if (this.primType.isByteArray()) {
            encoder.writeUTF(DrByteArrayUtil.toString((byte[])this.aval));
        } else if (this.primType.isFloat()) {
            encoder.writeDouble(this.fval);
        } else {
            encoder.writeLong(this.ival);
        }
    }

    public BObject decode(DataInput decoder) throws IOException {
        BAcePrimitiveTypeEnum tp = (BAcePrimitiveTypeEnum)BAcePrimitiveTypeEnum.DEFAULT.decode(decoder);
        this.status = (BStatus)this.status.decode(decoder);
        if (tp.isString()) {
            return new BAcePrimitive(tp, decoder.readUTF());
        }
        if (this.primType.isBool()) {
            return new BAcePrimitive(tp, this.status, decoder.readBoolean());
        }
        if (tp.isByteArray()) {
            return new BAcePrimitive(tp, DrByteArrayUtil.getBytes((String)decoder.readUTF()));
        }
        if (tp.isFloat()) {
            return new BAcePrimitive(tp, this.status, decoder.readDouble());
        }
        return new BAcePrimitive(tp, this.status, decoder.readLong());
    }

    public String encodeToString() throws IOException {
        try {
            String val = this.primType.isString() ? this.sval : (this.primType.isBool() ? Boolean.toString(this.bval) : (this.primType.isByteArray() ? DrByteArrayUtil.toString((byte[])this.aval) : (this.primType.isFloat() ? Double.toString(this.fval) : Long.toString(this.ival))));
            return this.primType.encodeToString() + ":" + val + ":" + this.status.encodeToString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public BObject decodeFromString(String s) throws IOException {
        String[] sa = s.split(":");
        BAcePrimitiveTypeEnum pType = (BAcePrimitiveTypeEnum)BAcePrimitiveTypeEnum.DEFAULT.decodeFromString(sa[0]);
        String val = sa[1];
        BStatus stat = (BStatus)this.status.decodeFromString(sa[2]);
        if (pType.isString()) {
            return new BAcePrimitive(pType, val);
        }
        if (pType.isBool()) {
            return new BAcePrimitive(pType, stat, Boolean.valueOf(val));
        }
        if (pType.isByteArray()) {
            return new BAcePrimitive(pType, DrByteArrayUtil.getBytes((String)sa[1]));
        }
        if (pType.isFloat()) {
            return new BAcePrimitive(pType, stat, Double.valueOf(val));
        }
        return new BAcePrimitive(pType, stat, Long.valueOf(val));
    }

    public String toString(Context cx) {
        try {
            String val = this.primType.isString() ? this.sval : (this.primType.isBool() ? Boolean.toString(this.bval) : (this.primType.isByteArray() ? DrByteArrayUtil.toString((byte[])this.aval) : (this.primType.isFloat() ? Double.toString(this.fval) : Long.toString(this.ival))));
            return this.primType.encodeToString() + (this.primType.isStatus() ? ":" + this.status.toString(cx) : "") + ":" + val;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

