/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.comm;

import com.tridium.ace.comm.BAceIpcCommConfig;
import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.platAceIpc.BAceIpcPlatformService;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class AceIpcLinkLayer
implements ILinkLayer {
    public static final BFacets showMilliSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    private Logger log;
    private boolean done = true;
    private Statistics stats = new Statistics();
    private final NComm comm;
    private final BAceIpcCommConfig comCfg;
    private final NLinkMessageFactory lnkFac;
    private Listener receive = null;
    private Thread rcvThread;
    private FileAccessStream in;
    private BAceIpcPlatformService service = null;

    public AceIpcLinkLayer(NComm comm, BAceIpcCommConfig comCfg) {
        this.comm = comm;
        this.comCfg = comCfg;
        this.lnkFac = comCfg.getLinkMessageFactory();
    }

    public void start() throws Exception {
        this.log().fine("start AceIpcLinkLayer");
        this.service = (BAceIpcPlatformService)Sys.getService((Type)BAceIpcPlatformService.TYPE);
        this.service.init();
        this.in = new FileAccessStream(this.service);
        this.done = false;
        this.receive = new Listener();
        this.rcvThread = new Thread((Runnable)this.receive, this.comCfg.getResourcePrefix() + ".LinkServer");
        this.rcvThread.start();
    }

    public void stop() {
        this.log().fine("stop AceIpcLinkLayer");
        this.done = true;
        if (this.rcvThread != null) {
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
            }
            catch (Exception e) {
                this.log().severe("Unable to close in stream:" + e);
            }
            this.rcvThread.interrupt();
        }
    }

    public void verifySettings(BCommConfig comCfg) throws Exception {
    }

    public void sendMessage(LinkMessage msg) throws Exception {
        if (this.done) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            System.out.println("send:" + AceIpcLinkLayer.timeStamp() + "|" + DrByteArrayUtil.toString((byte[])msg.getByteArray(), (int)msg.getLength()));
        }
        this.service.write(msg.getByteArray(), msg.getLength());
    }

    public void spy(SpyWriter out) throws Exception {
    }

    public void resetStats() {
        this.stats = new Statistics();
    }

    public static String timeStamp() {
        return BAbsTime.make((long)System.currentTimeMillis()).toTimeString((Context)showMilliSecs);
    }

    public final Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.comCfg.getResourcePrefix() + ".Link");
        }
        return this.log;
    }

    private class FileAccessStream
    extends InputStream {
        byte[] buf = new byte[4096];
        int len = 0;
        int pos = 0;
        private BAceIpcPlatformService service;

        public FileAccessStream(BAceIpcPlatformService fis) {
            this.service = fis;
        }

        @Override
        public int read() throws IOException {
            if (this.pos == this.len) {
                try {
                    this.len = this.service.read(this.buf, this.buf.length);
                }
                catch (Throwable e) {
                    AceIpcLinkLayer.this.log().severe("Exception caught in FileAccessStream.read ");
                    throw new IOException(e);
                }
                if (this.len < 0) {
                    this.pos = 0;
                    this.len = 0;
                    return -1;
                }
                this.pos = 0;
            }
            return Byte.toUnsignedInt(this.buf[this.pos++]);
        }
    }

    private class Listener
    implements Runnable {
        private Listener() {
        }

        @Override
        public void run() {
            while (!AceIpcLinkLayer.this.done) {
                boolean trace = AceIpcLinkLayer.this.log().isLoggable(Level.FINE);
                try {
                    LinkMessage tmsg = AceIpcLinkLayer.this.lnkFac.getLinkMessage();
                    boolean complete = tmsg.receive((InputStream)AceIpcLinkLayer.this.in);
                    if (complete) {
                        if (AceIpcLinkLayer.this.log.isLoggable(Level.FINE)) {
                            System.out.println("rcv: " + AceIpcLinkLayer.timeStamp() + "|" + DrByteArrayUtil.toString((byte[])tmsg.getByteArray(), (int)tmsg.getLength()));
                        }
                        AceIpcLinkLayer.this.comm.receiveMessage(tmsg);
                        ++((AceIpcLinkLayer)AceIpcLinkLayer.this).stats.msgReceived;
                        continue;
                    }
                    AceIpcLinkLayer.this.lnkFac.releaseLinkMessage(tmsg);
                }
                catch (Throwable e) {
                    if (AceIpcLinkLayer.this.done) break;
                    AceIpcLinkLayer.this.log().severe("Exception caught in AceIpcLinkLayer.Listener " + (e.getMessage() != null ? e.getMessage() : ""));
                    if (trace) {
                        e.printStackTrace();
                    }
                    ++((AceIpcLinkLayer)AceIpcLinkLayer.this).stats.receiveError;
                    AceIpcLinkLayer.this.done = true;
                }
            }
        }
    }

    public static class Statistics {
        long msgReceived = 0L;
        long receiveError = 0L;
    }
}

