/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.comm.AceListener;
import com.tridium.ace.comm.BAceIpcCommConfig;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.message.AceHeartBeat;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.message.AceWrite;
import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.platAceIpc.BAceIpcPlatformService;
import com.tridium.sys.Nre;
import com.tridium.util.ArrayUtil;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="commConfig", type="BCommConfig", defaultValue="new BAceIpcCommConfig()", override=true), @NiagaraProperty(name="local", type="BAceDevice", defaultValue="new BAceDevice()")})
@NiagaraAction(name="heartBeatTmo", flags=4)
public abstract class BAceIpcNetwork
extends BAceNetwork {
    @Generated
    public static final Property commConfig = BAceIpcNetwork.newProperty((int)0, (BValue)new BAceIpcCommConfig(), null);
    @Generated
    public static final Property local = BAceIpcNetwork.newProperty((int)0, (BValue)new BAceDevice(), null);
    @Generated
    public static final Action heartBeatTmo = BAceIpcNetwork.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAceIpcNetwork.class);
    Clock.Ticket hrtBtTicket = null;
    private static final int HEARTBEAT_INTERVAL = 15;
    private int appUtcOffset = 0;

    @Generated
    public BAceDevice getLocal() {
        return (BAceDevice)this.get(local);
    }

    @Generated
    public void setLocal(BAceDevice v) {
        this.set(local, (BValue)v, null);
    }

    @Generated
    public void heartBeatTmo() {
        this.invoke(heartBeatTmo, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void serviceStarted() throws Exception {
        super.serviceStarted();
        int cnt = 0;
        for (BComponent c : Nre.getServiceManager().getAllServices()) {
            if (!c.getType().is(this.getType())) continue;
            ++cnt;
        }
        if (cnt > 1) {
            String errString = LexiconText.make((Type)TYPE, (String)"ace.onlyOneInstance").getText(null);
            this.configFatal(errString);
        }
    }

    @Override
    public void aceNetworkStarted() throws Exception {
        super.aceNetworkStarted();
        this.getCommConfig().setDefaultListener((ICommListener)new AceListener(this.getCommConfig()));
        this.verifyAce(this.getEnabled());
        if (this.getEnabled()) {
            this.getLocal().unregisterAllCov();
        }
        this.startHeartBeat();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.getEnabled()) {
            this.getLocal().unregisterAllCov();
        }
        this.stopHeartBeat();
        if (Sys.getStation().isRunning()) {
            this.verifyAce(false);
            this.removeAceDir();
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(status)) {
            this.statusUpdate();
            this.startHeartBeat();
        }
    }

    private void startHeartBeat() {
        this.stopHeartBeat();
        if (!this.getEnabled()) {
            return;
        }
        this.hrtBtTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)15), (Action)heartBeatTmo, null);
    }

    private void stopHeartBeat() {
        if (this.hrtBtTicket != null) {
            this.hrtBtTicket.cancel();
        }
        this.hrtBtTicket = null;
    }

    public void doHeartBeatTmo() {
        if (!this.getLocal().isCommEnabled()) {
            this.stopHeartBeat();
            return;
        }
        try {
            AceHeartBeat msg = AceHeartBeat.make();
            msg.setAddress(this.getLocal().getAddress());
            this.ncomm().sendMessage((NMessage)msg);
        }
        catch (Exception e) {
            this.log().severe("Process heartbeat exception!");
        }
        int v = BAbsTime.now().getTimeZoneOffset();
        if (v != this.appUtcOffset) {
            this.setAppUtcOffset(v);
        }
    }

    private void statusUpdate() {
        if (!this.getAsync().isRunning()) {
            this.implStatusUpdate();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    BAceIpcNetwork.this.implStatusUpdate();
                }
            };
            this.postAsync(r);
        }
    }

    private void implStatusUpdate() {
        boolean enbld;
        boolean bl = enbld = this.getEnabled() && !this.getStatus().isFault();
        if (enbld) {
            this.verifyAce(enbld);
        }
        this.getCommConfig().statusUpdate();
        if (!enbld) {
            this.verifyAce(enbld);
        }
    }

    private void verifyAce(boolean set) {
        try {
            BAceIpcPlatformService service = (BAceIpcPlatformService)Sys.getService((Type)BAceIpcPlatformService.TYPE);
            this.verifyAce(service, set);
            try {
                AccessController.doPrivileged(() -> {
                    service.verifyEnable(set);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        catch (Exception e) {
            if (set) {
                this.log().severe("Unable to verify initialization of ace executable:" + e.getMessage());
                this.configFail("Unable to verify initialization of ace executable.");
            }
            this.log().severe("Unable to verify slay of ace executable:" + e.getMessage());
        }
    }

    private void removeAceDir() {
        try {
            BAceIpcPlatformService service = (BAceIpcPlatformService)Sys.getService((Type)BAceIpcPlatformService.TYPE);
            service.removeAce();
        }
        catch (Exception e) {
            this.log().severe("failed to delete ace directory:" + e.getMessage());
        }
    }

    protected void verifyAce(BAceIpcPlatformService srv, boolean set) {
    }

    @Override
    public BAceDevice getDevice(BAddress adr) {
        return this.getLocal();
    }

    public BINavNode[] getNavChildren() {
        Object[] kids = super.getNavChildren();
        return (BINavNode[])ArrayUtil.addOne((Object[])kids, (Object)((Object)this.getLocal()));
    }

    public void setAppUtcOffset(int v) {
        try {
            AceWrite wr = AceWrite.make(0, 26, BAcePrimitive.makeS32(v / 60000));
            wr.setAddress(this.getLocal().getAddress());
            AceMessage rsp = (AceMessage)this.ncomm().sendRequest((NMessage)wr);
            if (rsp.isError()) {
                this.log().severe("Send utcOffset message error!");
            } else {
                this.appUtcOffset = v;
            }
        }
        catch (Exception e) {
            this.log().log(Level.SEVERE, "Set appOsUtcOffset exception!", e);
        }
    }
}

