/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace;

import com.tridium.ace.BAceDeviceFolder;
import com.tridium.ace.BAceIpcNetwork;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.AceUtil;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.datatypes.BAcePrimitive;
import com.tridium.ace.datatypes.BAceReadParams;
import com.tridium.ace.datatypes.BAceWriteFileParams;
import com.tridium.ace.datatypes.BWriteWorker;
import com.tridium.ace.enums.BAceCovRegisterTypeEnum;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.KitRegistry;
import com.tridium.ace.message.AceCovRegistration;
import com.tridium.ace.message.AceMessage;
import com.tridium.ace.message.AceObjPropValue;
import com.tridium.ace.message.AceRead;
import com.tridium.ace.point.AcePointGatherer;
import com.tridium.ace.point.BAcePointDeviceExt;
import com.tridium.ace.point.BAceProxyExt;
import com.tridium.ace.point.DevicePointDescriptions;
import com.tridium.ace.point.OfflinePointGatherer;
import com.tridium.ace.point.PointDescriptions;
import com.tridium.ace.program.AceFileUtil;
import com.tridium.ace.program.BAceSaveAppJob;
import com.tridium.ace.program.BAceViewApp;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.util.CovReg;
import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.sys.station.Station;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, override=true), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="points", type="BAcePointDeviceExt", defaultValue="new BAcePointDeviceExt()"), @NiagaraProperty(name="address", type="BAddress", defaultValue="new BAddress()", flags=4), @NiagaraProperty(name="writeWorker", type="BWriteWorker", defaultValue="new BWriteWorker()", flags=4), @NiagaraProperty(name="Catalog", type="BOrd", defaultValue="BOrd.NULL", flags=4), @NiagaraProperty(name="AppFile", type="BOrd", defaultValue="BOrd.NULL", flags=4, facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"ace:AceAppFile\")")})})
@NiagaraActions(value={@NiagaraAction(name="readFile", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BBlob", flags=4), @NiagaraAction(name="writeFile", parameterType="BAceWriteFileParams", defaultValue="new BAceWriteFileParams()", flags=4), @NiagaraAction(name="viewApp", returnType="BOrd", flags=4), @NiagaraAction(name="restart", flags=4), @NiagaraAction(name="saveApp", flags=4), @NiagaraAction(name="saveAppJob", returnType="BOrd", flags=4), @NiagaraAction(name="readProp", parameterType="BAceReadParams", defaultValue="new BAceReadParams()", returnType="BAcePrimitive", flags=4)})
public class BAceDevice
extends BNDevice
implements BINPollable {
    @Generated
    public static final Property status = BAceDevice.newProperty((int)75, (BValue)BStatus.ok, null);
    @Generated
    public static final Property pollFrequency = BAceDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property points = BAceDevice.newProperty((int)0, (BValue)new BAcePointDeviceExt(), null);
    @Generated
    public static final Property address = BAceDevice.newProperty((int)4, (BValue)new BAddress(), null);
    @Generated
    public static final Property writeWorker = BAceDevice.newProperty((int)4, (BValue)new BWriteWorker(), null);
    @Generated
    public static final Property Catalog = BAceDevice.newProperty((int)4, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property AppFile = BAceDevice.newProperty((int)4, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"ace:AceAppFile")));
    @Generated
    public static final Action readFile = BAceDevice.newAction((int)4, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action writeFile = BAceDevice.newAction((int)4, (BValue)new BAceWriteFileParams(), null);
    @Generated
    public static final Action viewApp = BAceDevice.newAction((int)4, null);
    @Generated
    public static final Action restart = BAceDevice.newAction((int)4, null);
    @Generated
    public static final Action saveApp = BAceDevice.newAction((int)4, null);
    @Generated
    public static final Action saveAppJob = BAceDevice.newAction((int)4, null);
    @Generated
    public static final Action readProp = BAceDevice.newAction((int)4, (BValue)new BAceReadParams(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAceDevice.class);
    private static int nextSessionId = 1;
    boolean dirty = true;
    boolean haveApp = false;
    final Map<Integer, BAceComponent> compMap = new HashMap<Integer, BAceComponent>();
    private CovReg covReg;
    private final StationSaveListener stationSaveListener = new StationSaveListener();
    private static final Logger COV_LOG = BAceNetwork.COV_LOG;
    public static final Logger ACE_LOG = Logger.getLogger("AceNetwork");
    public final Object lock = new Object();
    public static final Object idLock = new Object();

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BAcePointDeviceExt getPoints() {
        return (BAcePointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BAcePointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BAddress getAddress() {
        return (BAddress)this.get(address);
    }

    @Generated
    public void setAddress(BAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Generated
    public BWriteWorker getWriteWorker() {
        return (BWriteWorker)this.get(writeWorker);
    }

    @Generated
    public void setWriteWorker(BWriteWorker v) {
        this.set(writeWorker, (BValue)v, null);
    }

    @Generated
    public BOrd getCatalog() {
        return (BOrd)this.get(Catalog);
    }

    @Generated
    public void setCatalog(BOrd v) {
        this.set(Catalog, (BValue)v, null);
    }

    @Generated
    public BOrd getAppFile() {
        return (BOrd)this.get(AppFile);
    }

    @Generated
    public void setAppFile(BOrd v) {
        this.set(AppFile, (BValue)v, null);
    }

    @Generated
    public BBlob readFile(BString parameter) {
        return (BBlob)this.invoke(readFile, (BValue)parameter, null);
    }

    @Generated
    public void writeFile(BAceWriteFileParams parameter) {
        this.invoke(writeFile, (BValue)parameter, null);
    }

    @Generated
    public BOrd viewApp() {
        return (BOrd)this.invoke(viewApp, null, null);
    }

    @Generated
    public void restart() {
        this.invoke(restart, null, null);
    }

    @Generated
    public void saveApp() {
        this.invoke(saveApp, null, null);
    }

    @Generated
    public BOrd saveAppJob() {
        return (BOrd)this.invoke(saveAppJob, null, null);
    }

    @Generated
    public BAcePrimitive readProp(BAceReadParams parameter) {
        return (BAcePrimitive)this.invoke(readProp, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BAceNetwork.TYPE;
    }

    public NComm comm() {
        return this.getAceNetwork().ncomm();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAceNetwork || parent instanceof BAceDeviceFolder;
    }

    public void started() throws Exception {
        super.started();
        this.covReg = new CovReg(this);
        if (!this.getAceNetwork().isFault()) {
            this.getAceNetwork().getPollScheduler().subscribe((BIPollable)this);
        }
        Station.addSaveListener((Station.SaveListener)this.stationSaveListener);
    }

    public void stopped() throws Exception {
        if (!this.getAceNetwork().isFault()) {
            this.getAceNetwork().getPollScheduler().unsubscribe((BIPollable)this);
        }
        Station.removeSaveListener((Station.SaveListener)this.stationSaveListener);
        super.stopped();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(status) && (this.getStatus().isDisabled() || this.getStatus().isFault()) && this.get("App") != null) {
            this.remove("App", BNNetwork.noWrite);
        }
    }

    public void checkRename(Property prop, String newName, Context cx) {
        super.checkRename(prop, newName, cx);
        if (!prop.getType().is(BAceApp.TYPE)) {
            return;
        }
        if (!newName.equals("App")) {
            throw new IllegalNameException("ace", "ace.cannotRenameApp", null);
        }
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        super.removed(p, oldValue, cx);
        if (!this.isRunning()) {
            return;
        }
        if (oldValue instanceof BAceApp) {
            this.unregisterAllCov();
            this.clearComponentCache();
            this.haveApp = false;
            if (!BNNetwork.noWrite.equals(cx)) {
                this.getAceNetwork().postAsync(new Runnable(){

                    @Override
                    public void run() {
                        BAceDevice.this.getPoints().reassertProxyCov();
                    }
                });
            }
        }
    }

    public void added(Property p, Context cx) {
        super.added(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.getType().is(BAceComponent.TYPE)) {
            this.clearComponentCache();
            this.haveApp = true;
        }
    }

    public boolean isOperational() {
        return this.isRunning() && this.getStatus().isValid();
    }

    public void reassertCov() {
        if (!this.isOperational()) {
            return;
        }
        if (this.get("App") != null) {
            BAceComponent[] comps;
            for (BAceComponent cp : comps = (BAceComponent[])DrUtil.getDecendantsByClass((BComponent)this, BAceComponent.class)) {
                cp.reassertCov();
            }
        }
        this.getPoints().reassertProxyCov();
    }

    public void reassertCov(int compId) {
        if (!this.isOperational()) {
            return;
        }
        if (this.get("App") != null) {
            BAceComponent cp = this.getComponent(compId);
            if (cp == null) {
                return;
            }
            cp.reassertCov();
        }
    }

    public void doPing() {
        if (!this.isCommEnabled()) {
            return;
        }
        try {
            AceRead rd = AceRead.make(0, 0);
            rd.setAddress(this.getAddress());
            this.comm().sendRequest((NMessage)rd);
            this.pingOk();
        }
        catch (Exception e) {
            this.pingFail("failed ping");
        }
    }

    public void updateProxyPoint(int oid, int pid, BAcePrimitive primVal) {
        BAceProxyExt pext = this.getPoints().getProxyExt(oid, pid);
        if (pext == null) {
            return;
        }
        pext.receiveUpdate(primVal);
    }

    public BOrd doViewApp() {
        return new BAceViewApp(this).submit(null);
    }

    public BOrd doSaveAppJob() {
        return new BAceSaveAppJob(this).submit(null);
    }

    public BAcePrimitive doReadProp(BAceReadParams rp) {
        try {
            AceObjPropValue[] aopv = AceUtil.readProps(this.comm(), this.getAddress(), rp.getObjectId(), rp.getPropId());
            return aopv[0].primVal;
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException("ace", "ace.errorReadingProp", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BBlob doReadFile(BString fileName) {
        BBlob blob;
        Object object = this.lock;
        synchronized (object) {
            byte[] appEmb = this.implReadFile(fileName.getString());
            if (appEmb == null) {
                return null;
            }
            blob = BBlob.make((byte[])appEmb);
        }
        return blob;
    }

    public byte[] implReadFile(String fileName) {
        try {
            return AceFileUtil.readFile(this, fileName);
        }
        catch (Exception e) {
            ACE_LOG.warning(e.getMessage());
            return null;
        }
    }

    public void doWriteFile(final BAceWriteFileParams param) {
        this.getAceNetwork().postAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = BAceDevice.this.lock;
                synchronized (object) {
                    BAceDevice.this.implWriteFile(param);
                }
            }
        });
    }

    public void implWriteFile(BAceWriteFileParams param) {
        try {
            BIFile file = (BIFile)param.getFileToWrite().resolve().get();
            try (InputStream in = file.getInputStream();){
                byte[] bin = new byte[in.available()];
                int len = in.read(bin);
                if (len <= 0) {
                    return;
                }
                AceFileUtil.writeFile(this, param.getFileNameInDevice(), bin);
            }
        }
        catch (Exception e) {
            ACE_LOG.warning(e.getMessage());
        }
    }

    public void doRestart() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BAceDevice.this.implRestart();
            }
        };
        this.getAceNetwork().postAsync(r);
    }

    public boolean implRestart() {
        boolean success = AceUtil.invokeAction(this.comm(), this.getAddress(), 0, 31, BAcePrimitive.makeNull(), true);
        DrUtil.wait((int)1000);
        this.doPing();
        ((BAceIpcNetwork)this.getAceNetwork()).setAppUtcOffset(BAbsTime.now().getTimeZoneOffset());
        this.reassertCov();
        return success;
    }

    public void doSaveApp() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BAceDevice.this.implSaveApp();
            }
        };
        this.getAceNetwork().postAsync(r);
    }

    public boolean implSaveApp() {
        ACE_LOG.fine("Invoking ACE app save action");
        boolean success = AceUtil.invokeAction(this.comm(), this.getAddress(), 0, 29, BAcePrimitive.makeNull(), true, 7000);
        ACE_LOG.fine("ACE app save complete");
        return success;
    }

    void unregisterAllCov() {
        try {
            AceCovRegistration covReg = AceCovRegistration.make(BAceCovRegisterTypeEnum.UnregisterAll);
            covReg.setAddress(this.getAddress());
            if (COV_LOG.isLoggable(Level.FINE)) {
                COV_LOG.fine("send:" + covReg.toTraceString());
            }
            AceMessage response = (AceMessage)this.comm().sendRequest((NMessage)covReg);
            if (COV_LOG.isLoggable(Level.FINE)) {
                COV_LOG.fine("rcv:" + response.toTraceString());
            }
        }
        catch (Exception e) {
            COV_LOG.warning("Error sending covRegister UnregisterAll :" + e.getMessage());
        }
    }

    public void doPoll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextSessionId() {
        int id;
        Object object = idLock;
        synchronized (object) {
            id = nextSessionId++;
            if (nextSessionId >= 255) {
                nextSessionId = 1;
            }
        }
        return id;
    }

    public final BAceNetwork getAceNetwork() {
        return (BAceNetwork)DrUtil.getParent((BComplex)this, (Type)BAceNetwork.TYPE);
    }

    public boolean isCommEnabled() {
        return this.isRunning() && this.getEnabled() && !this.isFault() && this.getAceNetwork().getEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAceComponent getComponent(int compId) {
        BAceComponent cp;
        if (!this.haveApp) {
            return null;
        }
        Map<Integer, BAceComponent> map = this.compMap;
        synchronized (map) {
            if (this.dirty) {
                this.updateComponentCache();
            }
            if ((cp = this.compMap.get(compId)) != null && !cp.isMounted()) {
                this.updateComponentCache();
                cp = this.compMap.get(compId);
            }
            if (cp == null && ACE_LOG.isLoggable(Level.WARNING)) {
                ACE_LOG.warning("AceComponent{" + compId + "} is not in cache");
            }
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearComponentCache() {
        if (ACE_LOG.isLoggable(Level.FINE)) {
            ACE_LOG.fine("*** clearComponentCache");
        }
        Map<Integer, BAceComponent> map = this.compMap;
        synchronized (map) {
            this.dirty = true;
            this.compMap.clear();
        }
    }

    private void updateComponentCache() {
        BAceComponent[] ca;
        if (ACE_LOG.isLoggable(Level.FINE)) {
            ACE_LOG.fine("*** updateComponentCache");
        }
        this.compMap.clear();
        for (BAceComponent c : ca = (BAceComponent[])DrUtil.getDecendantsByClass((BComponent)this, BAceComponent.class)) {
            if (c.getObjectId() < 0) continue;
            this.compMap.put(c.getObjectId(), c);
        }
        this.dirty = false;
    }

    public PointDescriptions loadPointDescriptionsOnline() throws Exception {
        KitRegistry catalog = this.getAceNetwork().getNetworkKitRegistry();
        AcePointGatherer gatherer = new AcePointGatherer(this, catalog);
        DevicePointDescriptions pointDescriptions = new DevicePointDescriptions();
        gatherer.gatherAllAppComponents(pointDescriptions);
        return pointDescriptions;
    }

    public PointDescriptions loadPointDescriptionsOffline() throws Exception {
        Catalog catalog = this.loadCatalog();
        OfflinePointGatherer gatherer = new OfflinePointGatherer(this.getAppFile(), catalog);
        DevicePointDescriptions points = new DevicePointDescriptions();
        gatherer.gatherAllAppComponents(points);
        return points;
    }

    public Catalog loadCatalog() {
        return this.getAceNetwork().getNetworkKitRegistry();
    }

    public CovReg covReg() {
        return this.covReg;
    }

    private class StationSaveListener
    implements Station.SaveListener {
        private StationSaveListener() {
        }

        public void stationSave() throws Exception {
            if (!BAceDevice.this.isCommEnabled()) {
                ACE_LOG.info("No comm - could not save ACE application");
                return;
            }
            BAceDevice.this.implSaveApp();
        }

        public void stationSaveOk() throws Exception {
        }

        public void stationSaveFail(String cause) throws Exception {
        }
    }
}

