/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.virtual;

import com.tridium.sys.schema.ComponentSlotMap;
import java.security.AccessController;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.virtual.BVirtualGateway;

public class VirtualCacheCallbacks {
    public static final BRelTime MAX_CACHE_LIFE = BRelTime.make(AccessController.doPrivileged(() -> (long)Long.getLong("niagara.virtual.cache.maxLifeDefault", 45000L)));
    public static final BRelTime MIN_CACHE_LIFE = BRelTime.make(AccessController.doPrivileged(() -> (long)Long.getLong("niagara.virtual.cache.minLifeDefault", 25000L)));
    public static final int VIRTUAL_THRESHOLD = AccessController.doPrivileged(() -> (int)Integer.getInteger("niagara.virtual.cache.threshold", 1000));
    public static final long VIRTUAL_THRESHOLD_SCAN_RATE = AccessController.doPrivileged(() -> (long)Long.getLong("niagara.virtual.cache.thresholdScanRate", 1000L));
    public static final int THREAD_POOL_SIZE = AccessController.doPrivileged(() -> (int)Integer.getInteger("niagara.virtual.cache.threadPoolSize", 10));
    public static final int SPACES_PER_THREAD = AccessController.doPrivileged(() -> Integer.getInteger("niagara.virtual.cache.spacesPerThread", 5));
    private static final long TIMEOUT_ON_KILL = 5000L;
    static VirtualCleanupThread[] vcThreadPool = new VirtualCleanupThread[THREAD_POOL_SIZE];
    static VirtualThresholdThread vThresholdThread = null;
    static Context virtualRemoveContext = BFacets.make("virtualCacheRemove", BBoolean.TRUE);
    BVirtualComponentSpace space;
    static final Logger log = Logger.getLogger("virtual.cache");

    public VirtualCacheCallbacks(BVirtualComponentSpace space) {
        this.space = space;
    }

    public synchronized void start() {
        if (vThresholdThread == null) {
            vThresholdThread = new VirtualThresholdThread();
            vThresholdThread.start();
            log.fine("Virtual:Threshold Thread started");
        }
        vThresholdThread.register(this.space, this);
        int currentMinSize = Integer.MAX_VALUE;
        int minIdx = 0;
        for (int i = 0; i < THREAD_POOL_SIZE; ++i) {
            int size;
            if (vcThreadPool[i] == null) {
                VirtualCacheCallbacks.vcThreadPool[i] = new VirtualCleanupThread(i);
                vcThreadPool[i].start();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Virtual:Cleanup" + i + " Thread started");
                }
            }
            if ((size = vcThreadPool[i].size()) < SPACES_PER_THREAD) {
                vcThreadPool[i].register(this.space, this);
                return;
            }
            if (size >= currentMinSize) continue;
            currentMinSize = size;
            minIdx = i;
        }
        vcThreadPool[minIdx].register(this.space, this);
    }

    public synchronized void stop() {
        for (int i = 0; i < THREAD_POOL_SIZE; ++i) {
            if (vcThreadPool[i] == null || !vcThreadPool[i].contains(this.space)) continue;
            if (vcThreadPool[i].unregister(this.space) > 0) break;
            vcThreadPool[i].kill();
            VirtualCacheCallbacks.vcThreadPool[i] = null;
            if (!log.isLoggable(Level.FINE)) break;
            log.fine("Virtual:Cleanup" + i + " Thread stopped");
            break;
        }
        if (vThresholdThread != null && vThresholdThread.unregister(this.space) <= 0) {
            vThresholdThread.kill();
            vThresholdThread = null;
            log.fine("Virtual:Threshold Thread stopped");
        }
    }

    public BRelTime getMaxVirtualCacheLife() {
        return MAX_CACHE_LIFE;
    }

    public BRelTime getMinVirtualCacheLife() {
        return MIN_CACHE_LIFE;
    }

    public BVirtualComponentSpace getSpace() {
        return this.space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("VirtualCacheCallbacks", 2);
        out.prop((Object)"MAX_CACHE_LIFE", MAX_CACHE_LIFE);
        out.prop((Object)"MIN_CACHE_LIFE", MIN_CACHE_LIFE);
        out.prop((Object)"THREAD_POOL_SIZE", THREAD_POOL_SIZE);
        out.prop((Object)"SPACES_PER_THREAD", SPACES_PER_THREAD);
        out.prop((Object)"VIRTUAL_THRESHOLD", VIRTUAL_THRESHOLD);
        if (VIRTUAL_THRESHOLD_SCAN_RATE <= 0L) {
            out.prop((Object)"VIRTUAL_THRESHOLD_SCAN_RATE", VIRTUAL_THRESHOLD_SCAN_RATE + " (disabled)");
        } else {
            out.prop((Object)"VIRTUAL_THRESHOLD_SCAN_RATE", VIRTUAL_THRESHOLD_SCAN_RATE + " (" + BRelTime.make(VIRTUAL_THRESHOLD_SCAN_RATE) + ")");
        }
        out.prop((Object)"maxVirtualCacheLife", this.getMaxVirtualCacheLife());
        out.prop((Object)"minVirtualCacheLife", this.getMinVirtualCacheLife());
        out.prop((Object)"vThresholdThread", vThresholdThread.toString());
        out.prop((Object)"__totalSpacesManaged", "" + vThresholdThread.size());
        Object object = VirtualCacheCallbacks.vThresholdThread.lock;
        synchronized (object) {
            out.prop((Object)"__numScans", "" + VirtualCacheCallbacks.vThresholdThread.numScans);
            out.prop((Object)"__lastScanTicks", VirtualCacheCallbacks.vThresholdThread.lastScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vThresholdThread.lastScanTicks) + ")");
            out.prop((Object)"__minScanTicks", VirtualCacheCallbacks.vThresholdThread.minScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vThresholdThread.minScanTicks) + ")");
            out.prop((Object)"__maxScanTicks", VirtualCacheCallbacks.vThresholdThread.maxScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vThresholdThread.maxScanTicks) + ")");
            if (VirtualCacheCallbacks.vThresholdThread.numScans > 0L) {
                double avgScan = (double)VirtualCacheCallbacks.vThresholdThread.sumScanTicks / (double)VirtualCacheCallbacks.vThresholdThread.numScans;
                out.prop((Object)"__avgScanTicks", avgScan + " (" + BRelTime.make((long)avgScan) + ")");
            }
        }
        for (int i = 0; i < THREAD_POOL_SIZE; ++i) {
            if (vcThreadPool[i] == null) continue;
            out.prop((Object)("Thread '" + vcThreadPool[i].getName() + "'"), "Spaces managed: " + vcThreadPool[i].size() + (vcThreadPool[i].contains(this.space) ? " (includes this space)" : ""));
            StringBuilder sb = new StringBuilder();
            VirtualCacheCallbacks[] caches = null;
            Object object2 = VirtualCacheCallbacks.vcThreadPool[i].map;
            synchronized (object2) {
                caches = VirtualCacheCallbacks.vcThreadPool[i].map.values().toArray(new VirtualCacheCallbacks[0]);
            }
            if (caches != null) {
                for (int j = 0; j < caches.length; ++j) {
                    BVirtualGateway gateway = caches[j].space.getVirtualGateway();
                    if (gateway == null) continue;
                    if (j > 0) {
                        sb.append("; ");
                    }
                    sb.append(gateway.getSlotPath().getBody());
                }
            }
            out.prop((Object)"__spaces", sb.toString());
            object2 = VirtualCacheCallbacks.vcThreadPool[i].lock;
            synchronized (object2) {
                out.prop((Object)"__numScans", "" + VirtualCacheCallbacks.vcThreadPool[i].numScans);
                out.prop((Object)"__lastScanTicks", VirtualCacheCallbacks.vcThreadPool[i].lastScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vcThreadPool[i].lastScanTicks) + ")");
                out.prop((Object)"__minScanTicks", VirtualCacheCallbacks.vcThreadPool[i].minScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vcThreadPool[i].minScanTicks) + ")");
                out.prop((Object)"__maxScanTicks", VirtualCacheCallbacks.vcThreadPool[i].maxScanTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vcThreadPool[i].maxScanTicks) + ")");
                if (VirtualCacheCallbacks.vcThreadPool[i].numScans > 0L) {
                    double avgScan = (double)VirtualCacheCallbacks.vcThreadPool[i].sumScanTicks / (double)VirtualCacheCallbacks.vcThreadPool[i].numScans;
                    out.prop((Object)"__avgScanTicks", avgScan + " (" + BRelTime.make((long)avgScan) + ")");
                }
                out.prop((Object)"__lastSleepTicks", VirtualCacheCallbacks.vcThreadPool[i].lastSleepTicks + " (" + BRelTime.make(VirtualCacheCallbacks.vcThreadPool[i].lastSleepTicks) + ")");
                if (VirtualCacheCallbacks.vcThreadPool[i].numScans > 0L) {
                    double avgSleep = (double)VirtualCacheCallbacks.vcThreadPool[i].sumSleepTicks / (double)VirtualCacheCallbacks.vcThreadPool[i].numScans;
                    out.prop((Object)"__avgSleepTicks", avgSleep + " (" + BRelTime.make((long)avgSleep) + ")");
                }
                continue;
            }
        }
        out.endProps();
    }

    private static VirtualChildInfo cleanupExpiredVirtuals(BComponent root, BComponent comp, long cacheLife) {
        BComponent[] children;
        long shortestTicksTillCleanup = -1L;
        boolean hasActiveChildren = false;
        if (comp != null && (children = comp.getChildComponents()) != null) {
            for (int i = 0; i < children.length; ++i) {
                BComponent kid = children[i];
                VirtualChildInfo info = VirtualCacheCallbacks.cleanupExpiredVirtuals(root, kid, cacheLife);
                long childrenCleanupTicks = info.cleanupTicks;
                hasActiveChildren |= info.hasActiveChildren;
                if (childrenCleanupTicks >= 0L) {
                    long l = shortestTicksTillCleanup = shortestTicksTillCleanup < 0L ? childrenCleanupTicks : Math.min(shortestTicksTillCleanup, childrenCleanupTicks);
                }
                if (!kid.isSubscribed()) {
                    if (kid != root && kid instanceof BVirtualComponent && ((BVirtualComponent)kid).performAutoRemoval() && !info.hasActiveChildren) {
                        long expiredTicksSinceLastUnsubscribed = Clock.ticks() - ((BVirtualComponent)kid).getLastActiveTicks();
                        if (expiredTicksSinceLastUnsubscribed >= cacheLife) {
                            try {
                                BComponent parent = kid.getParent().asComponent();
                                if (parent == null) continue;
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("Virtual cache max life expired, auto removing " + kid.getNavOrd());
                                }
                                parent.remove(kid.getPropertyInParent(), virtualRemoveContext);
                                ((ComponentSlotMap)parent.fw(1)).setBrokerPropsLoaded(false);
                            }
                            catch (Exception parent) {}
                            continue;
                        }
                        if (expiredTicksSinceLastUnsubscribed < 0L) continue;
                        long ticksTillNextCleanup = cacheLife - expiredTicksSinceLastUnsubscribed;
                        shortestTicksTillCleanup = shortestTicksTillCleanup < 0L ? ticksTillNextCleanup : Math.min(ticksTillNextCleanup, shortestTicksTillCleanup);
                        hasActiveChildren = true;
                        continue;
                    }
                    if (!(kid instanceof BVirtualComponent)) continue;
                    hasActiveChildren = true;
                    continue;
                }
                hasActiveChildren = true;
            }
        }
        return new VirtualChildInfo(shortestTicksTillCleanup, hasActiveChildren);
    }

    private static VirtualThresholdInfo mapVirtualsIntoTierBuckets(HashMap<Integer, Array<VirtualComponentInfo>> tierBuckets, BComponent root, BComponent comp, long minLife) {
        BComponent[] children;
        int tier = 0;
        int size = 0;
        if (comp != null && (children = comp.getChildComponents()) != null && children.length > 0) {
            ++tier;
            int highestChildTier = 0;
            for (int i = 0; i < children.length; ++i) {
                BComponent kid = children[i];
                VirtualThresholdInfo info = VirtualCacheCallbacks.mapVirtualsIntoTierBuckets(tierBuckets, root, kid, minLife);
                highestChildTier = Math.max(highestChildTier, info.tier);
                size += info.size;
            }
            tier += highestChildTier;
        }
        if (comp instanceof BVirtualComponent && comp != root) {
            BVirtualComponent vComp = (BVirtualComponent)comp;
            ++size;
            Array bucket = tierBuckets.get(tier);
            if (bucket == null) {
                bucket = new Array(VirtualComponentInfo.class);
                tierBuckets.put(tier, (Array<VirtualComponentInfo>)bucket);
            }
            bucket.add((Object)new VirtualComponentInfo(vComp, minLife));
        }
        return new VirtualThresholdInfo(tier, size);
    }

    static class VirtualComponentInfo {
        BVirtualComponent vComp;
        long minLife;

        VirtualComponentInfo(BVirtualComponent vComp, long minLife) {
            this.vComp = vComp;
            this.minLife = minLife;
        }
    }

    static class VirtualThresholdInfo {
        int tier;
        int size;

        VirtualThresholdInfo(int tier, int size) {
            this.tier = tier;
            this.size = size;
        }
    }

    class VirtualThresholdThread
    extends Thread {
        boolean alive;
        final HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> map;
        final Object lock;
        long lastScanTicks;
        long minScanTicks;
        long maxScanTicks;
        long sumScanTicks;
        long numScans;

        VirtualThresholdThread() {
            super("Virtual:Threshold");
            this.alive = true;
            this.map = new HashMap();
            this.lock = new Object();
            this.lastScanTicks = 0L;
            this.minScanTicks = Long.MAX_VALUE;
            this.maxScanTicks = Long.MIN_VALUE;
            this.sumScanTicks = 0L;
            this.numScans = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Object object = this.lock;
            synchronized (object) {
                if (this.alive) {
                    this.alive = false;
                    this.interrupt();
                    try {
                        this.lock.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(BVirtualComponentSpace vSpace, VirtualCacheCallbacks vcc) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getName() + " registering " + vSpace.getNavOrd());
            }
            HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
            synchronized (hashMap) {
                this.map.put(vSpace, vcc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int unregister(BVirtualComponentSpace vSpace) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getName() + " unregistering " + vSpace.getNavOrd());
            }
            HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
            synchronized (hashMap) {
                this.map.remove(vSpace);
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int size() {
            HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
            synchronized (hashMap) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean contains(BVirtualComponentSpace vSpace) {
            HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
            synchronized (hashMap) {
                return this.map.containsKey(vSpace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (VIRTUAL_THRESHOLD_SCAN_RATE <= 0L) {
                return;
            }
            while (this.alive) {
                try {
                    long scanStartTicks = Clock.ticks();
                    VirtualCacheCallbacks[] caches = null;
                    Object object = this.map;
                    synchronized (object) {
                        caches = this.map.values().toArray(new VirtualCacheCallbacks[0]);
                    }
                    if (caches != null) {
                        HashMap tierBuckets = new HashMap();
                        int maxTier = -1;
                        int size = 0;
                        for (int i = 0; i < caches.length; ++i) {
                            BComponent root = caches[i].space.getRootComponent();
                            VirtualThresholdInfo info = VirtualCacheCallbacks.mapVirtualsIntoTierBuckets(tierBuckets, root, root, caches[i].getMinVirtualCacheLife().getMillis());
                            size += info.size;
                            maxTier = Math.max(info.tier, maxTier);
                        }
                        int numToClean = size - VIRTUAL_THRESHOLD;
                        if (numToClean > 0 && maxTier >= 0) {
                            for (int i = 0; i < maxTier; ++i) {
                                long expiredTicksSinceLastUnsubscribed;
                                int j;
                                Array bucket = (Array)tierBuckets.get(i);
                                Object[] vInfo = (VirtualComponentInfo[])bucket.trim();
                                int len = vInfo.length;
                                Object[] lastActiveTicks = new Long[len];
                                for (j = 0; j < len; ++j) {
                                    BComponent[] children;
                                    long ticks = -1L;
                                    if (!((VirtualComponentInfo)vInfo[j]).vComp.isSubscribed() && ((VirtualComponentInfo)vInfo[j]).vComp.performAutoRemoval() && (expiredTicksSinceLastUnsubscribed = Clock.ticks() - ((VirtualComponentInfo)vInfo[j]).vComp.getLastActiveTicks()) >= ((VirtualComponentInfo)vInfo[j]).minLife && ((children = ((VirtualComponentInfo)vInfo[j]).vComp.getChildComponents()) == null || children.length == 0)) {
                                        ticks = ((VirtualComponentInfo)vInfo[j]).vComp.getLastActiveTicks();
                                    }
                                    lastActiveTicks[j] = ticks;
                                }
                                SortUtil.sort((Object[])lastActiveTicks, (Object[])vInfo);
                                for (j = 0; j < vInfo.length; ++j) {
                                    if ((Long)lastActiveTicks[j] < 0L || !((VirtualComponentInfo)vInfo[j]).vComp.isRunning()) continue;
                                    try {
                                        int k;
                                        BComponent parent = ((VirtualComponentInfo)vInfo[j]).vComp.getParent().asComponent();
                                        if (parent == null) continue;
                                        if (log.isLoggable(Level.FINE)) {
                                            log.fine("Virtual cache min life expired, auto removing " + ((VirtualComponentInfo)vInfo[j]).vComp.getNavOrd());
                                        }
                                        parent.remove(((VirtualComponentInfo)vInfo[j]).vComp.getPropertyInParent(), virtualRemoveContext);
                                        ((ComponentSlotMap)parent.fw(1)).setBrokerPropsLoaded(false);
                                        if (--numToClean <= 0) break;
                                        BComponent[] children = parent.getChildComponents();
                                        if (!(parent instanceof BVirtualComponent) || parent.isSubscribed() || !((BVirtualComponent)parent).performAutoRemoval() || children != null && children.length != 0 || (expiredTicksSinceLastUnsubscribed = Clock.ticks() - ((BVirtualComponent)parent).getLastActiveTicks()) < ((VirtualComponentInfo)vInfo[j]).minLife) continue;
                                        int insertIdx = vInfo.length;
                                        int newSize = insertIdx + 1;
                                        long ticks = ((BVirtualComponent)parent).getLastActiveTicks();
                                        for (int k2 = j + 1; k2 < vInfo.length; ++k2) {
                                            if ((Long)lastActiveTicks[k2] <= ticks) continue;
                                            insertIdx = k2;
                                            break;
                                        }
                                        VirtualComponentInfo[] tmpInfo = new VirtualComponentInfo[newSize];
                                        Long[] tmpTicks = new Long[newSize];
                                        for (k = 0; k < insertIdx; ++k) {
                                            tmpInfo[k] = vInfo[k];
                                            tmpTicks[k] = lastActiveTicks[k];
                                        }
                                        tmpInfo[insertIdx] = new VirtualComponentInfo((BVirtualComponent)parent, ((VirtualComponentInfo)vInfo[j]).minLife);
                                        tmpTicks[insertIdx] = ticks;
                                        for (k = insertIdx; k < newSize - 1; ++k) {
                                            tmpInfo[k + 1] = vInfo[k];
                                            tmpTicks[k + 1] = lastActiveTicks[k];
                                        }
                                        vInfo = tmpInfo;
                                        lastActiveTicks = tmpTicks;
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (numToClean <= 0) break;
                            }
                        }
                    }
                    object = this.lock;
                    synchronized (object) {
                        this.lastScanTicks = Clock.ticks() - scanStartTicks;
                        this.minScanTicks = Math.min(this.lastScanTicks, this.minScanTicks);
                        this.maxScanTicks = Math.max(this.lastScanTicks, this.maxScanTicks);
                        this.sumScanTicks += this.lastScanTicks;
                        ++this.numScans;
                    }
                    Thread.sleep(VIRTUAL_THRESHOLD_SCAN_RATE);
                }
                catch (InterruptedException scanStartTicks) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    static class VirtualChildInfo {
        long cleanupTicks;
        boolean hasActiveChildren;

        VirtualChildInfo(long cleanupTicks, boolean hasActiveChildren) {
            this.cleanupTicks = cleanupTicks;
            this.hasActiveChildren = hasActiveChildren;
        }
    }

    class VirtualCleanupThread
    extends Thread {
        boolean alive;
        final HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> map;
        final Object lock;
        long lastScanTicks;
        long minScanTicks;
        long maxScanTicks;
        long sumScanTicks;
        long numScans;
        long lastSleepTicks;
        long sumSleepTicks;

        VirtualCleanupThread(int id) {
            super("Virtual:Cleanup" + id);
            this.alive = true;
            this.map = new HashMap();
            this.lock = new Object();
            this.lastScanTicks = 0L;
            this.minScanTicks = Long.MAX_VALUE;
            this.maxScanTicks = Long.MIN_VALUE;
            this.sumScanTicks = 0L;
            this.numScans = 0L;
            this.lastSleepTicks = 0L;
            this.sumSleepTicks = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Object object = this.lock;
            synchronized (object) {
                if (this.alive) {
                    this.alive = false;
                    this.interrupt();
                    try {
                        this.lock.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(BVirtualComponentSpace vSpace, VirtualCacheCallbacks vcc) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getName() + " registering " + vSpace.getNavOrd());
            }
            HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
            synchronized (hashMap) {
                this.map.put(vSpace, vcc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int unregister(BVirtualComponentSpace vSpace) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getName() + " unregistering " + vSpace.getNavOrd());
            }
            HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
            synchronized (hashMap) {
                this.map.remove(vSpace);
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int size() {
            HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
            synchronized (hashMap) {
                return this.map.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean contains(BVirtualComponentSpace vSpace) {
            HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
            synchronized (hashMap) {
                return this.map.containsKey(vSpace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long sleepTicks = 1000L;
            while (this.alive) {
                try {
                    long scanStartTicks = Clock.ticks();
                    VirtualCacheCallbacks[] caches = null;
                    HashMap<BVirtualComponentSpace, VirtualCacheCallbacks> hashMap = this.map;
                    synchronized (hashMap) {
                        caches = this.map.values().toArray(new VirtualCacheCallbacks[0]);
                    }
                    long ticksTillNextCleanup = -1L;
                    if (caches != null) {
                        for (int i = 0; i < caches.length; ++i) {
                            BComponent root = caches[i].space.getRootComponent();
                            long cacheLife = caches[i].getMaxVirtualCacheLife().getMillis();
                            sleepTicks = i > 0 ? Math.min(cacheLife, sleepTicks) : cacheLife;
                            VirtualChildInfo info = VirtualCacheCallbacks.cleanupExpiredVirtuals(root, root, cacheLife);
                            long currentTicksTillNextCleanup = info.cleanupTicks;
                            if (currentTicksTillNextCleanup >= 0L) {
                                if (ticksTillNextCleanup >= 0L) {
                                    ticksTillNextCleanup = Math.min(ticksTillNextCleanup, currentTicksTillNextCleanup);
                                    continue;
                                }
                                ticksTillNextCleanup = currentTicksTillNextCleanup;
                                continue;
                            }
                            if (info.hasActiveChildren) continue;
                            ((ComponentSlotMap)root.fw(1)).setBrokerPropsLoaded(false);
                        }
                    }
                    if (ticksTillNextCleanup >= 0L) {
                        sleepTicks = ticksTillNextCleanup + 1000L;
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        this.lastScanTicks = Clock.ticks() - scanStartTicks;
                        this.minScanTicks = Math.min(this.lastScanTicks, this.minScanTicks);
                        this.maxScanTicks = Math.max(this.lastScanTicks, this.maxScanTicks);
                        this.sumScanTicks += this.lastScanTicks;
                        this.lastSleepTicks = sleepTicks;
                        this.sumSleepTicks += this.lastSleepTicks;
                        ++this.numScans;
                    }
                    Thread.sleep(sleepTicks);
                }
                catch (InterruptedException scanStartTicks) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

