/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Deprecated
public class StringToIntMap {
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;

    public StringToIntMap() {
        this(31, 0.75f);
    }

    public StringToIntMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public StringToIntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Iterator<String> keys() {
        return new StringToIntMapIterator();
    }

    public int get(String key) {
        return this.get(key, -1);
    }

    public synchronized int get(String key, int nullValue) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return nullValue;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized void put(String key, int value) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            this.put(key, value);
            return;
        }
        e = new Entry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
    }

    public synchronized void remove(String key) {
        Entry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return;
            }
            prev = e;
            e = e.next;
        }
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringToIntMap)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        StringToIntMap o = (StringToIntMap)obj;
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                int tv = entry.value;
                int ov = o.get(entry.key);
                if (ov != tv) {
                    return false;
                }
                entry = entry.next;
            }
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.table);
    }

    public synchronized Object clone() {
        StringToIntMap c = new StringToIntMap(this.size() * 3);
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                c.put(entry.key, entry.value);
                entry = entry.next;
            }
        }
        return c;
    }

    static class Entry {
        int hash;
        String key;
        int value;
        Entry next;

        Entry() {
        }

        public int hashCode() {
            return this.hash;
        }
    }

    class StringToIntMapIterator
    implements Iterator<String> {
        private int index;
        private Entry entry;

        StringToIntMapIterator() {
            this.index = StringToIntMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = StringToIntMap.this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public String next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = StringToIntMap.this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry e = this.entry;
                this.entry = e.next;
                return e.key;
            }
            throw new NoSuchElementException("IntHashtable");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

