/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

public final class ConcurrencyUtil {
    public static ThreadFactory defaultThreadFactory(final Supplier<String> threadNamePrefixSupplier) {
        if (threadNamePrefixSupplier == null) {
            return Executors.defaultThreadFactory();
        }
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = Executors.defaultThreadFactory().newThread(r);
                result.setName(String.format("%s-%s", threadNamePrefixSupplier.get(), result.getName()));
                return result;
            }
        };
    }

    public static ThreadFactory defaultThreadFactory(String threadNamePrefix) {
        return ConcurrencyUtil.defaultThreadFactory(() -> threadNamePrefix);
    }
}

