/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;

@NiagaraType
public final class BTypeSpec
extends BSimple
implements BIComparable {
    public static final BTypeSpec NULL = new BTypeSpec();
    public static final BTypeSpec DEFAULT;
    public static final Type TYPE;
    private String spec;
    private String moduleName;
    private String typeName;
    private Type type;

    public static BTypeSpec make(String moduleName, String typeName) {
        if (moduleName == null || typeName == null) {
            throw new NullPointerException();
        }
        BTypeSpec ts = new BTypeSpec();
        ts.moduleName = moduleName;
        ts.typeName = typeName;
        ts.spec = moduleName + ':' + typeName;
        return (BTypeSpec)ts.intern();
    }

    public static BTypeSpec make(String spec) {
        if (spec.equals("null")) {
            return NULL;
        }
        try {
            BTypeSpec ts = new BTypeSpec();
            int colon = spec.indexOf(58);
            ts.moduleName = spec.substring(0, colon);
            ts.typeName = spec.substring(colon + 1);
            ts.spec = spec;
            return (BTypeSpec)ts.intern();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(spec);
        }
    }

    public static BTypeSpec make(Type type) {
        BTypeSpec ts = new BTypeSpec();
        ts.moduleName = type.getModule().getModuleName();
        ts.typeName = type.getTypeName();
        ts.spec = ts.moduleName + ":" + ts.typeName;
        ts = (BTypeSpec)ts.intern();
        ts.type = type;
        return ts;
    }

    private BTypeSpec() {
    }

    @Override
    public int compareTo(Object obj) {
        return this.spec.compareTo(((BTypeSpec)obj).spec);
    }

    @Override
    public boolean isNull() {
        return this.spec.equals("null");
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public TypeInfo getTypeInfo() {
        return Sys.getRegistry().getType(this.spec);
    }

    public Type getResolvedType() throws ModuleException, TypeException {
        if (this.type == null) {
            for (NModule module : Nre.getModuleManager().loadModuleParts(this.moduleName)) {
                if (!module.hasType(this.typeName)) continue;
                return module.getType(this.typeName);
            }
            throw new TypeNotFoundException(this.moduleName + ":" + this.typeName);
        }
        return this.type;
    }

    public BObject getInstance() throws ModuleException, TypeException {
        return this.getResolvedType().getInstance();
    }

    @Override
    public int hashCode() {
        return this.spec.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BTypeSpec && this.spec.equals(((BTypeSpec)obj).spec);
    }

    @Override
    public String toString(Context context) {
        return this.spec;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.spec);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BTypeSpec.make(in.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        return this.spec;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BTypeSpec.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid type spec: " + s);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        BTypeSpec.NULL.spec = "null";
        DEFAULT = NULL;
        TYPE = Sys.loadType(BTypeSpec.class);
    }
}

