/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraSingleton
public final class BStationNameValidator
extends BObject
implements BIValidator {
    @Generated
    public static final BStationNameValidator INSTANCE = new BStationNameValidator();
    @Generated
    public static final Type TYPE = Sys.loadType(BStationNameValidator.class);
    private static final Lexicon lex = Lexicon.make(BStationNameValidator.class);
    private static final int maxStationNameLength = 32;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void validate(BObject value, Context cx) throws CannotValidateException {
        String stationName = value.toString();
        if (!SlotPath.isValidName(stationName)) {
            throw new CannotValidateException(lex.getText("stationNameValidator.invalidName"));
        }
        if (stationName.length() > 32) {
            throw new CannotValidateException(lex.getText("stationNameValidator.nameTooLong"));
        }
    }
}

