/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import com.tridium.util.CompUtil;
import com.tridium.util.ComponentTreeCursor;
import com.tridium.util.ObjectUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInterface;
import javax.baja.sys.BStation;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;

@NiagaraType
public interface BIRestrictedComponent
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BIRestrictedComponent.class);

    default public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent(parent, this);
    }

    public static void checkParentForRestrictedComponent(BComponent parent, BIRestrictedComponent child) {
        BIRestrictedComponent.checkParentIsServiceContainer(parent, child);
        BIRestrictedComponent.checkForDuplicates(parent, child, false);
    }

    public static void checkParentIsServiceContainer(BComponent parent, BIRestrictedComponent child) {
        if (!parent.getType().is(BServiceContainer.TYPE)) {
            throw new IllegalChildException("baja", "RestrictedToServiceContainer", new Object[]{parent.getType(), child.getType()});
        }
    }

    public static void checkForDuplicates(BComponent parent, BIRestrictedComponent child, boolean allowNonExactTypes) {
        BStation station = ObjectUtil.getStation(parent.getComponentSpace());
        if (station == null) {
            return;
        }
        BServiceContainer services = station.getServices();
        try (ComponentTreeCursor cursor = new ComponentTreeCursor(services, null);){
            CompUtil.checkForDuplicateRestrictedComponent(cursor, parent, child, allowNonExactTypes, "baja", "DuplicateRestrictedComponent");
        }
    }

    public static void checkForDuplicatesInParent(BComponent parent, BIRestrictedComponent child, boolean allowNonExactTypes) {
        try (SlotCursor<Property> slots = parent.getProperties();){
            CompUtil.checkForDuplicateRestrictedComponent(slots, parent, child, allowNonExactTypes, "baja", "DuplicateRestrictedComponentInParent");
        }
    }

    public static void checkContextForSuperUser(BIRestrictedComponent component, Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
            throw new IllegalChildException("baja", "RestrictedServiceException", new Object[]{component.getType()});
        }
    }
}

