/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BClassSpec
extends BSimple {
    public static final BClassSpec NULL = new BClassSpec();
    public static final BClassSpec DEFAULT;
    public static final Type TYPE;
    private String spec;
    private String moduleName;
    private String className;
    private Class<?> cls;

    public static BClassSpec make(String moduleName, String className) {
        if (moduleName == null || className == null) {
            throw new NullPointerException();
        }
        BClassSpec cs = new BClassSpec();
        cs.moduleName = moduleName;
        cs.className = className;
        cs.spec = moduleName + ':' + className;
        return (BClassSpec)cs.intern();
    }

    public static BClassSpec make(String spec) {
        if (spec.equals("null")) {
            return NULL;
        }
        try {
            BClassSpec cs = new BClassSpec();
            int colon = spec.indexOf(58);
            cs.moduleName = spec.substring(0, colon);
            cs.className = spec.substring(colon + 1);
            cs.spec = spec;
            return (BClassSpec)cs.intern();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(spec);
        }
    }

    public static BClassSpec make(BModule module, Class<?> cls) {
        BClassSpec cs = new BClassSpec();
        cs.moduleName = module.getModuleName();
        cs.className = cls.getName();
        cs.spec = cs.moduleName + ":" + cs.className;
        cs = (BClassSpec)cs.intern();
        cs.cls = cls;
        return cs;
    }

    public static BClassSpec make(Class<?> cls) {
        BClassSpec cs = new BClassSpec();
        cs.moduleName = Sys.getModuleForClass(cls).getModuleName();
        cs.className = cls.getName();
        cs.spec = cs.moduleName + ":" + cs.className;
        cs = (BClassSpec)cs.intern();
        cs.cls = cls;
        return cs;
    }

    private BClassSpec() {
    }

    @Override
    public boolean isNull() {
        return this.spec.equals("null");
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getResolvedClass() throws IOException, ModuleException, ClassNotFoundException {
        if (this.cls == null) {
            BModule module = Sys.loadModule(this.moduleName);
            if (module == null) {
                throw new ModuleException("Should never happen");
            }
            this.cls = module.loadClass(this.className);
            return this.cls;
        }
        return this.cls;
    }

    public Object newInstance() throws IOException, ModuleException, IllegalAccessException, InstantiationException, ClassNotFoundException, ClassCastException {
        return this.getResolvedClass().newInstance();
    }

    @Override
    public int hashCode() {
        return this.spec.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BClassSpec) {
            return this.spec.equals(((BClassSpec)obj).spec);
        }
        return false;
    }

    @Override
    public String toString(Context context) {
        return this.spec;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.spec);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BClassSpec.make(in.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        return this.spec;
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BClassSpec.make(s);
        }
        catch (RuntimeException e) {
            throw new IOException("Invalid type spec: " + s);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        BClassSpec.NULL.spec = "null";
        DEFAULT = NULL;
        TYPE = Sys.loadType(BClassSpec.class);
    }
}

