/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.timezone;

import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;

public class TimeZoneDatabase {
    private static String[] supportedZones;
    private static TimeZoneDatabase INSTANCE;

    private TimeZoneDatabase() {
    }

    public static final synchronized TimeZoneDatabase get() {
        if (INSTANCE == null) {
            INSTANCE = new TimeZoneDatabase();
        }
        return INSTANCE;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static BTimeZone getTimeZone(String id) {
        TimeZoneDatabase.get();
        return BTimeZone.getTimeZone(id);
    }

    public static final boolean isZoneIdSupported(String id) {
        if (id.equals("NULL")) {
            return true;
        }
        if (supportedZones != null) {
            for (int zoneIdx = 0; zoneIdx < supportedZones.length; zoneIdx = (int)((short)(zoneIdx + 1))) {
                if (!supportedZones[zoneIdx].equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public static final String[] getAllSupportedZoneIds() {
        return supportedZones;
    }

    public final synchronized BTimeZone[] getTimeZones() {
        ArrayList<BTimeZone> timeZones = new ArrayList<BTimeZone>();
        for (int i = 0; i < supportedZones.length; ++i) {
            timeZones.add(BTimeZone.getTimeZone(supportedZones[i]));
        }
        return timeZones.toArray(new BTimeZone[0]);
    }

    static {
        ArrayList<String> olsonSupportedZones = new ArrayList<String>();
        String[] javaSupportedZones = TimeZone.getAvailableIDs();
        for (int i = 0; i < javaSupportedZones.length; ++i) {
            try {
                ZoneRulesProvider.getRules(javaSupportedZones[i], false);
                olsonSupportedZones.add(javaSupportedZones[i]);
                continue;
            }
            catch (ZoneRulesException zoneRulesException) {
                // empty catch block
            }
        }
        supportedZones = olsonSupportedZones.toArray(new String[0]);
    }
}

