/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.collection.CompoundIterator;
import javax.baja.collection.FilteredIterator;
import javax.baja.data.BIDataValue;
import javax.baja.tag.Id;
import javax.baja.tag.SmartTags;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;

public class SmartTagSet
implements SmartTags {
    private Tags directTags;
    private Tags impliedTags;

    public SmartTagSet(Tags impliedTags, Tags directTags) {
        this.impliedTags = impliedTags;
        this.directTags = directTags;
    }

    @Override
    public Tags getDirectTags() {
        return this.directTags;
    }

    @Override
    public Tags getImpliedTags() {
        return this.impliedTags;
    }

    @Override
    public boolean isMulti(Id id) {
        if (this.directTags.contains(id)) {
            return this.directTags.get(id).get() instanceof Collection;
        }
        return this.impliedTags.isMulti(id);
    }

    @Override
    public boolean set(Tag tag) {
        return this.directTags.set(tag);
    }

    @Override
    public boolean setMulti(Id id, Collection<? extends BIDataValue> values) {
        return this.directTags.setMulti(id, values);
    }

    @Override
    public boolean addMulti(Id id, Collection<? extends BIDataValue> values) {
        return this.directTags.addMulti(id, values);
    }

    @Override
    public boolean merge(Collection<Tag> tags) {
        return this.directTags.merge(tags);
    }

    @Override
    public boolean remove(Id id, BIDataValue value) {
        return this.directTags.remove(id, value);
    }

    @Override
    public boolean removeAll(Id id) {
        return this.directTags.removeAll(id);
    }

    @Override
    public Iterator<Tag> iterator() {
        Iterator[] subs = new Iterator[]{new FilteredIterator<Tag>(new ExcludeDirectDupsFilter(), this.impliedTags.iterator()), this.directTags.iterator()};
        return new CompoundIterator<Tag>(subs);
    }

    @Override
    public Collection<Tag> getAll() {
        ArrayList<Tag> all = new ArrayList<Tag>();
        Iterator<Tag> i = this.impliedTags.filter(new ExcludeDirectDupsFilter()).iterator();
        while (i.hasNext()) {
            all.add(i.next());
        }
        i = this.directTags.iterator();
        while (i.hasNext()) {
            all.add(i.next());
        }
        return all;
    }

    @Override
    public Collection<Tag> filter(Predicate<Tag> f) {
        ArrayList<Tag> all = new ArrayList<Tag>();
        Collection<Tag> filteredSmart = this.impliedTags.filter(new CompoundPredicate(new ExcludeDirectDupsFilter(), f));
        Collection<Tag> filteredDirect = this.directTags.filter(f);
        all.addAll(filteredSmart);
        all.addAll(filteredDirect);
        return all;
    }

    @Override
    public Optional<BIDataValue> get(Id id) {
        Optional<BIDataValue> o = this.directTags.get(id);
        if (o.isPresent()) {
            return o;
        }
        return this.impliedTags.get(id);
    }

    private class CompoundPredicate
    implements Predicate<Tag> {
        private Predicate<Tag> p1;
        private Predicate<Tag> p2;

        public CompoundPredicate(Predicate<Tag> p1, Predicate<Tag> p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public boolean test(Tag tag) {
            return this.p1.test(tag) && this.p2.test(tag);
        }
    }

    private class ExcludeDirectDupsFilter
    implements Predicate<Tag> {
        private ExcludeDirectDupsFilter() {
        }

        @Override
        public boolean test(Tag tag) {
            return !SmartTagSet.this.directTags.get(tag.getId()).isPresent();
        }
    }
}

