/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag.util;

import com.tridium.tag.RelationKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.collection.CompoundIterator;
import javax.baja.collection.FilteredIterator;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Relations;
import javax.baja.tag.util.ImpliedRelations;

public class SmartRelationSet
implements Relations {
    private final Relations smart;
    private final Relations direct;

    public SmartRelationSet(Relations smart, Relations direct) {
        this.smart = smart;
        this.direct = direct;
    }

    @Override
    public Collection<Relation> set(Id id, Collection<? extends Entity> endpoints) {
        return this.direct.set(id, endpoints);
    }

    @Override
    public Collection<Relation> set(Id id, Collection<? extends Entity> endpoints, boolean isInbound) {
        return this.direct.set(id, endpoints, isInbound);
    }

    @Override
    public Relation set(Id id, Entity endpoint) {
        return this.direct.set(id, endpoint);
    }

    @Override
    public Relation add(Relation relation) {
        return this.direct.add(relation);
    }

    @Override
    public Relation add(Id id, Entity endpoint, boolean isInbound) {
        return this.direct.add(id, endpoint, isInbound);
    }

    @Override
    public Collection<Relation> add(Id id, Collection<? extends Entity> endpoints) {
        return this.direct.add(id, endpoints);
    }

    @Override
    public boolean remove(Relation relation) {
        return this.direct.remove(relation);
    }

    @Override
    public boolean remove(Id id, Entity endpoint) {
        return this.direct.remove(id, endpoint);
    }

    @Override
    public boolean removeAll(Id id) {
        return this.direct.removeAll(id);
    }

    @Override
    public Collection<Relation> filter(Predicate<Relation> condition, int direction) {
        ArrayList<Relation> result = new ArrayList<Relation>();
        for (Relation relation : this) {
            if (!condition.test(relation) || !ImpliedRelations.isMatchingDirection(relation, direction)) continue;
            result.add(relation);
        }
        return result;
    }

    @Override
    public Collection<Relation> getAll() {
        return SmartRelationSet.mergeRelations(this.direct.getAll(), this.smart.getAll());
    }

    @Override
    public Collection<Relation> getAll(int direction) {
        return SmartRelationSet.mergeRelations(this.direct.getAll(direction), this.smart.getAll(direction));
    }

    @Override
    public Optional<Relation> get(Id id) {
        Optional<Relation> r = this.direct.get(id);
        return r.isPresent() ? r : this.smart.get(id);
    }

    @Override
    public Optional<Relation> get(Id id, int direction) {
        Optional<Relation> r = this.direct.get(id, direction);
        return r.isPresent() ? r : this.smart.get(id, direction);
    }

    @Override
    public Collection<Relation> getAll(Id id) {
        return SmartRelationSet.mergeRelations(this.direct.getAll(id), this.smart.getAll(id));
    }

    @Override
    public Collection<Relation> getAll(Id id, int direction) {
        return SmartRelationSet.mergeRelations(this.direct.getAll(id, direction), this.smart.getAll(id, direction));
    }

    @Override
    public Optional<Relation> get(Id id, Entity endpoint) {
        Optional<Relation> r = this.direct.get(id, endpoint);
        return r.isPresent() ? r : this.smart.get(id, endpoint);
    }

    @Override
    public Optional<Relation> get(Id id, Entity endpoint, int direction) {
        Optional<Relation> r = this.direct.get(id, endpoint, direction);
        return r.isPresent() ? r : this.smart.get(id, endpoint, direction);
    }

    @Override
    public Iterator<Relation> iterator() {
        Iterator[] subs = new Iterator[]{new FilteredIterator<Relation>(new ExcludeDirectDuplicatesFilter(), this.smart.iterator()), this.direct.iterator()};
        return new CompoundIterator<Relation>(subs);
    }

    @Override
    public boolean isEmpty() {
        return this.smart.isEmpty() && this.direct.isEmpty();
    }

    private static Collection<Relation> mergeRelations(Collection<Relation> directs, Collection<Relation> smarts) {
        if (directs.isEmpty()) {
            return smarts;
        }
        if (smarts.isEmpty()) {
            return directs;
        }
        int directsSize = directs.size();
        ArrayList<Relation> result = new ArrayList<Relation>(directsSize + smarts.size());
        result.addAll(directs);
        HashSet<RelationKey> set = new HashSet<RelationKey>(directsSize);
        for (Relation direct : directs) {
            set.add(new RelationKey(direct.getId(), direct.getEndpoint(), direct.getEndpointOrd(), SmartRelationSet.getDirection(direct)));
        }
        RelationKey smartKey = new RelationKey();
        for (Relation smart : smarts) {
            smartKey.setId(smart.getId());
            smartKey.setEndpoint(smart.getEndpoint());
            smartKey.setEndpointOrd(smart.getEndpointOrd());
            smartKey.setDirection(SmartRelationSet.getDirection(smart));
            if (set.contains(smartKey)) continue;
            result.add(smart);
        }
        return result;
    }

    private static int getDirection(Relation relation) {
        if (relation.isInbound()) {
            return relation.isOutbound() ? 3 : 1;
        }
        return relation.isOutbound() ? 2 : 0;
    }

    private class ExcludeDirectDuplicatesFilter
    implements Predicate<Relation> {
        private ExcludeDirectDuplicatesFilter() {
        }

        @Override
        public boolean test(Relation relation) {
            int direction = relation.isOutbound() ? 2 : 1;
            return !SmartRelationSet.this.direct.get(relation.getId(), relation.getEndpoint(), direction).isPresent();
        }
    }
}

