/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.data.TypeMismatchException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.Taggable;

public interface TagInfo {
    public Optional<TagDictionary> getDictionary();

    public String getName();

    default public Id getTagId() {
        Optional<TagDictionary> d = this.getDictionary();
        if (d.isPresent()) {
            return Id.newId(d.get().getNamespace(), this.getName());
        }
        return Id.newId("", this.getName());
    }

    default public boolean isIdealFor(Type type) {
        return true;
    }

    default public boolean isValidFor(Entity entity) {
        return true;
    }

    public BIDataValue getDefaultValue();

    default public Tag getTag(Entity entity) {
        return this.makeTag();
    }

    default public TypeInfo getTagType() {
        return this.getDefaultValue().getType().getTypeInfo();
    }

    default public Tag makeTag() {
        Optional<TagDictionary> td = this.getDictionary();
        if (td.isPresent()) {
            return new Tag(this.getTagId(), this.getDefaultValue());
        }
        throw new IllegalStateException("TagInfo must be in a dictionary.");
    }

    default public void setTagOn(Taggable target) {
        target.tags().set(this.getTagId(), this.getDefaultValue());
    }

    default public void setTagOn(Taggable target, BIDataValue value) {
        if (this.getDefaultValue().getType() != value.getType()) {
            throw new TypeMismatchException(this.getDefaultValue().getType(), value.getType());
        }
        target.tags().set(this.getTagId(), value);
    }
}

