/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.baja.tag.DataPolicy;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.SmartTagDictionary;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagInfo;

public interface TagDictionaryService {
    public String getDefaultNamespace();

    public void setDefaultNamespace(String var1);

    public Optional<TagDictionary> getTagDictionary(String var1);

    public Collection<TagDictionary> getTagDictionaries();

    public Optional<SmartTagDictionary> getSmartTagDictionary(String var1);

    public Collection<SmartTagDictionary> getSmartTagDictionaries();

    default public Optional<Tag> getImpliedTag(Id id, Entity entity) {
        for (SmartTagDictionary smartDictionary : this.getSmartTagDictionaries()) {
            Optional<TagInfo> tagInfo;
            if (!smartDictionary.getEnabled() || !(tagInfo = smartDictionary.getImpliedTagInfo(id, entity)).isPresent()) continue;
            return Optional.ofNullable(tagInfo.get().getTag(entity));
        }
        return Optional.empty();
    }

    default public Collection<Tag> getImpliedTags(Entity entity) {
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (SmartTagDictionary smartDictionary : this.getSmartTagDictionaries()) {
            if (!smartDictionary.getEnabled()) continue;
            smartDictionary.addAllImpliedTags(entity, result);
        }
        return result;
    }

    public Optional<Relation> getImpliedRelation(Id var1, Entity var2);

    public void addAllImpliedRelations(Entity var1, Collection<Relation> var2);

    default public Collection<Relation> getAllImpliedRelations(Entity source) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        this.addAllImpliedRelations(source, relations);
        return relations;
    }

    public void addImpliedRelations(Id var1, Entity var2, Collection<Relation> var3);

    default public Collection<Relation> getImpliedRelations(Id id, Entity entity) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        this.addImpliedRelations(id, entity, relations);
        return relations;
    }

    public void tagAdded(Entity var1, Id var2);

    public void tagRemoved(Entity var1, Id var2);

    public Optional<DataPolicy> getDataPolicyForTag(Id var1);
}

