/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tag;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;

public interface Relations
extends Iterable<Relation> {
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int BOTH = 3;

    public Collection<Relation> set(Id var1, Collection<? extends Entity> var2);

    public Collection<Relation> set(Id var1, Collection<? extends Entity> var2, boolean var3);

    default public Relation set(Id id, Entity endpoint) {
        return this.set(id, Collections.singletonList(endpoint), true).iterator().next();
    }

    public Relation add(Relation var1);

    default public Relation add(Id id, Entity endpoint) {
        return this.add(id, endpoint, false);
    }

    default public Relation add(Id id, Entity endpoint, boolean isInbound) {
        return this.add(new BasicRelation(id, endpoint, isInbound));
    }

    default public Collection<Relation> add(Id id, Collection<? extends Entity> endpoints) {
        LinkedHashSet<Relation> added = new LinkedHashSet<Relation>();
        for (Entity entity : endpoints) {
            added.add(this.add(id, entity, false));
        }
        return added;
    }

    default public Collection<Relation> add(Id id, Collection<? extends Entity> endpoints, boolean isInbound) {
        LinkedHashSet<Relation> added = new LinkedHashSet<Relation>();
        for (Entity entity : endpoints) {
            added.add(this.add(id, entity, isInbound));
        }
        return added;
    }

    public boolean remove(Relation var1);

    default public boolean remove(Id id, Entity endpoint) {
        return this.remove(new BasicRelation(id, endpoint));
    }

    default public boolean removeAll(Id id) {
        boolean changed = false;
        for (Relation relation : this.getAll(id)) {
            changed |= this.remove(relation.getId(), relation.getEndpoint());
        }
        return changed;
    }

    public Collection<Relation> filter(Predicate<Relation> var1, int var2);

    default public Collection<Relation> getAll() {
        return this.getAll(3);
    }

    default public Collection<Relation> getAll(int direction) {
        return this.filter(Objects::nonNull, direction);
    }

    default public Optional<Relation> get(Id id) {
        return this.filter(r -> r.getId().equals(id), 3).stream().findFirst();
    }

    default public Optional<Relation> get(Id id, int direction) {
        return this.filter(r -> r.getId().equals(id), direction).stream().findFirst();
    }

    default public Collection<Relation> getAll(Id id) {
        return this.filter(r -> r.getId().equals(id), 3);
    }

    default public Collection<Relation> getAll(Id id, int direction) {
        return this.filter(r -> r.getId().equals(id), direction);
    }

    default public Optional<Relation> get(Id id, Entity endpoint) {
        return this.getAll(id).stream().filter(r -> r.getEndpoint().equals(endpoint)).findFirst();
    }

    default public Optional<Relation> get(Id id, Entity endpoint, int direction) {
        return this.getAll(id, direction).stream().filter(r -> r.getEndpoint().equals(endpoint)).findFirst();
    }

    @Override
    default public Iterator<Relation> iterator() {
        return this.getAll().iterator();
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }
}

