/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.util.HashMap;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public final class Validatable {
    private BComplex existing;
    private Property[] modifiedProperties;
    private BValue[] modifiedValues;
    private HashMap<Property, BValue> proposed;

    public Validatable(BComplex existing, Property[] modifiedProperties, BValue[] modifiedValues) {
        this.existing = existing;
        this.modifiedProperties = modifiedProperties;
        this.modifiedValues = modifiedValues;
        this.proposed = new HashMap(modifiedProperties.length);
        for (int i = 0; i < modifiedProperties.length; ++i) {
            this.proposed.put(modifiedProperties[i], modifiedValues[i]);
        }
    }

    public BValue getProposedValue(Property property) {
        BValue val = this.proposed.get(property);
        if (val != null) {
            return val;
        }
        return this.getExistingValue(property);
    }

    public BValue getProposedValue(String propertyName) {
        Property prop = this.existing.getProperty(propertyName);
        if (prop != null) {
            return this.getProposedValue(prop);
        }
        return null;
    }

    public BValue getExistingValue(Property property) {
        return this.existing.get(property);
    }

    public BValue getExistingValue(String propertyName) {
        return this.existing.get(propertyName);
    }

    public BComplex getExistingComplex() {
        return this.existing;
    }

    public Property[] getModifiedProperties() {
        return this.modifiedProperties;
    }

    public BValue[] getModifiedValues() {
        return this.modifiedValues;
    }

    public boolean isRunning() {
        BComponent comp = this.existing.getParentComponent();
        if (comp != null) {
            return comp.isRunning();
        }
        return false;
    }
}

