/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.baja.sys.Cursor;
import javax.baja.sys.CursorException;

public interface IterableCursor<E>
extends Cursor<E>,
Iterable<E> {
    @Override
    default public Iterator<E> iterator() {
        return IterableCursor.iterator(this);
    }

    @Override
    default public Spliterator<E> spliterator() {
        return IterableCursor.spliterator(this);
    }

    default public Stream<E> stream() {
        return IterableCursor.stream(this);
    }

    default public Stream<E> stream(boolean closeCursor) {
        return IterableCursor.stream(this, closeCursor);
    }

    public static <V> Iterator<V> iterator(Cursor<V> cursor) {
        return IterableCursor.stream(cursor).iterator();
    }

    public static <V> Spliterator<V> spliterator(final Cursor<V> cursor) {
        return new Spliterators.AbstractSpliterator<V>(0L, 0){

            @Override
            public boolean tryAdvance(Consumer<? super V> consumer) {
                try {
                    boolean next = cursor.next();
                    if (next) {
                        consumer.accept(cursor.get());
                    }
                    return next;
                }
                catch (CursorException cursorException) {
                    return false;
                }
            }
        };
    }

    public static <V> Stream<V> stream(Cursor<V> cursor) {
        return StreamSupport.stream(IterableCursor.spliterator(cursor), false);
    }

    public static <V> Stream<V> stream(Cursor<V> cursor, boolean closeCursor) {
        if (closeCursor) {
            return (Stream)IterableCursor.stream(cursor).onClose(() -> cursor.close());
        }
        return IterableCursor.stream(cursor);
    }
}

