/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.sys.Nre;
import java.security.AccessController;
import java.security.Permission;
import java.util.logging.Logger;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;

public class Clock {
    private static Logger log = Logger.getLogger("sys.clock");
    private static final Object timeLock = new Object();
    private static long lastMillis;
    private static BAbsTime lastTime;
    public static final Ticket expiredTicket;

    public static long ticks() {
        return PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getTickCount();
    }

    public static long nanoTicks() {
        return PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.getNanoCount();
    }

    public static long millis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BAbsTime time(int tolerance) {
        Object object = timeLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            long delta = now - lastMillis;
            if (delta > (long)tolerance || -delta > (long)tolerance) {
                lastMillis = now;
                lastTime = BAbsTime.make(now);
            }
            return lastTime;
        }
    }

    public static BAbsTime time() {
        return Clock.time(100);
    }

    public static BAbsTime nextTopOfMinute() {
        long nowMillis = System.currentTimeMillis();
        BAbsTime now = BAbsTime.make(nowMillis);
        return BAbsTime.make(nowMillis + 60000L - (long)(now.getSecond() * 1000) - (long)now.getMillisecond());
    }

    public static void setTime(BAbsTime time) {
        NiagaraBasicPermission setTimePermission = new NiagaraBasicPermission("SET_TIME");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)setTimePermission);
        }
        AccessController.doPrivileged(() -> {
            if (!PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.isSystemTimeReadonly()) {
                log.info("Changing system time " + Clock.time(0) + " -> " + time);
                PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.setSystemTime(time.getMillis());
                return null;
            }
            log.info("System time readonly, can not process setTime() request");
            return null;
        });
    }

    public static Ticket schedule(BComponent target, BRelTime time, Action action, BValue arg) {
        return Nre.getEngineManager().schedule(target, time, action, arg);
    }

    public static Ticket schedule(BComponent target, BAbsTime time, Action action, BValue arg) {
        return Nre.getEngineManager().schedule(target, time, action, arg);
    }

    public static Ticket schedulePeriodically(BComponent target, BRelTime period, Action action, BValue arg) {
        return Nre.getEngineManager().schedulePeriodically(target, period, action, arg);
    }

    public static Ticket schedulePeriodically(BComponent target, BAbsTime start, BRelTime period, Action action, BValue arg) {
        return Nre.getEngineManager().schedulePeriodically(target, start, period, action, arg);
    }

    static {
        expiredTicket = new ExpiredTicket();
    }

    private static final class PlatformProviderHolder {
        private static final IPlatformProvider PLATFORM_PROVIDER_INSTANCE = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);

        private PlatformProviderHolder() {
        }
    }

    private static class ExpiredTicket
    implements Ticket {
        private ExpiredTicket() {
        }

        @Override
        public void cancel() {
        }

        @Override
        public boolean isExpired() {
            return true;
        }

        @Override
        public BComponent getComponent() {
            return null;
        }

        @Override
        public Action getAction() {
            return null;
        }

        @Override
        public BValue getActionArgument() {
            return null;
        }

        public String toString() {
            return "Ticket: expired";
        }
    }

    public static interface Ticket {
        public void cancel();

        public boolean isExpired();

        public BComponent getComponent();

        public Action getAction();

        public BValue getActionArgument();
    }
}

