/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.util.TimeFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BITime;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BTime
extends BSimple
implements BITime,
BIComparable {
    public static final BTime DEFAULT;
    public static final BTime MIDNIGHT;
    public static final Type TYPE;
    private int bits;

    public static BTime make(BAbsTime absTime) {
        return BTime.make(absTime.getHour(), absTime.getMinute(), absTime.getSecond(), absTime.getMillisecond());
    }

    public static BTime make(BRelTime relTime) {
        long ms = relTime.getMillis();
        int hour = (int)((ms %= 86400000L) / 3600000L);
        int min = (int)((ms %= 3600000L) / 60000L);
        int sec = (int)((ms %= 60000L) / 1000L);
        return BTime.make(hour, min, sec, (int)(ms %= 1000L));
    }

    public static BTime make(int hour, int min, int sec) {
        return BTime.make(hour, min, sec, 0);
    }

    public static BTime make(int hour, int min, int sec, int ms) {
        if (hour < 0 || hour > 23 || min < 0 || min > 59 || sec < 0 || sec > 59 || ms < 0 || ms > 999) {
            throw new IllegalArgumentException("Invalid field: " + hour + ":" + min + ":" + sec + "." + ms);
        }
        if (hour == 0 && min == 0 && sec == 0 && ms == 0) {
            return DEFAULT;
        }
        return (BTime)new BTime(hour, min, sec, ms).intern();
    }

    private BTime(int hour, int min, int sec, int ms) {
        this.bits = hour << 27 | min << 21 | sec << 15 | ms;
    }

    @Override
    public final int getHour() {
        return this.bits >> 27 & 0x1F;
    }

    @Override
    public final int getMinute() {
        return this.bits >> 21 & 0x3F;
    }

    @Override
    public final int getSecond() {
        return this.bits >> 15 & 0x3F;
    }

    @Override
    public final int getMillisecond() {
        return this.bits & Short.MAX_VALUE;
    }

    @Override
    public final long getTimeOfDayMillis() {
        long retern = (long)this.getHour() * 3600000L;
        retern += (long)this.getMinute() * 60000L;
        retern += (long)this.getSecond() * 1000L;
        return retern += (long)this.getMillisecond();
    }

    public final BTime add(BRelTime duration) {
        return BTime.make(BRelTime.make(duration.getMillis() + this.getTimeOfDayMillis()));
    }

    @Override
    public String toString(Context context) {
        return TimeFormat.format(this, context);
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof BTime)) {
            return 0;
        }
        long mine = (long)this.bits & 0xFFFFFFFFFL;
        long his = (long)((BTime)obj).bits & 0xFFFFFFFFFL;
        if (mine < his) {
            return -1;
        }
        if (mine == his) {
            return 0;
        }
        return 1;
    }

    public boolean isBefore(BTime x) {
        return this.compareTo(x) < 0;
    }

    public boolean isAfter(BTime x) {
        return this.compareTo(x) > 0;
    }

    @Override
    public int hashCode() {
        return this.bits;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BTime) {
            return ((BTime)obj).bits == this.bits;
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeByte(this.getHour());
        out.writeByte(this.getMinute());
        out.writeByte(this.getSecond());
        out.writeShort(this.getMillisecond());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BTime.make(in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedByte(), in.readUnsignedShort());
    }

    @Override
    public String encodeToString() {
        StringBuilder s = new StringBuilder(32);
        int hour = this.getHour();
        if (hour < 10) {
            s.append('0');
        }
        s.append(hour).append(':');
        int min = this.getMinute();
        if (min < 10) {
            s.append('0');
        }
        s.append(min).append(':');
        int sec = this.getSecond();
        if (sec < 10) {
            s.append('0');
        }
        s.append(sec).append('.');
        int millis = this.getMillisecond();
        if (millis < 10) {
            s.append('0');
        }
        if (millis < 100) {
            s.append('0');
        }
        s.append(millis);
        return s.toString();
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        char[] c = s.toCharArray();
        try {
            int i = 0;
            int hour = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int min = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int sec = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '.') {
                throw new Exception();
            }
            int ms = (c[i++] - 48) * 100 + (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            return BTime.make(hour, min, sec, ms);
        }
        catch (Exception e) {
            throw new IOException("Invalid BTime: " + s);
        }
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 116) {
            if (this.getMillisecond() != 0) {
                return Boolean.TRUE;
            }
            return null;
        }
        return super.fw(x, a, b, c, d);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        MIDNIGHT = DEFAULT = new BTime(0, 0, 0, 0);
        TYPE = Sys.loadType(BTime.class);
    }
}

