/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import com.tridium.sys.module.BModuleNavNode;
import java.util.TreeSet;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.ModuleInfo;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
@NiagaraSingleton
public class BModuleSpace
extends BSpace {
    @Generated
    public static final BModuleSpace INSTANCE = new BModuleSpace();
    @Generated
    public static final Type TYPE = Sys.loadType(BModuleSpace.class);
    private static final BIcon icon;
    private static final BOrd ordInSession;
    private final Object loadLock = new Object();
    private volatile boolean loaded;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    private BModuleSpace() {
        super("modules", LexiconText.make("baja", "nav.modules"));
    }

    @Override
    public BOrd getOrdInSession() {
        return ordInSession;
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        this.lazyLoad();
        return super.getNavChild(navName);
    }

    @Override
    public BINavNode[] getNavChildren() {
        this.lazyLoad();
        return super.getNavChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyLoad() {
        if (this.loaded) {
            return;
        }
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loaded) {
                return;
            }
            TreeSet<String> moduleNames = new TreeSet<String>();
            for (ModuleInfo m : Sys.getRegistry().getModules()) {
                moduleNames.add(m.getModuleName());
            }
            moduleNames.forEach(moduleName -> this.addNavChild(new BModuleNavNode((String)moduleName)));
            this.loaded = true;
        }
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    static {
        BLocalHost.INSTANCE.addNavChild(INSTANCE);
        BLocalHost.INSTANCE.mountSpace(INSTANCE);
        icon = BIcon.std("navOnly/modules.png");
        ordInSession = BOrd.make("module:");
    }
}

