/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.RelationKnob;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BComponentEvent
extends BStruct {
    @Generated
    public static final Type TYPE = Sys.loadType(BComponentEvent.class);
    public static final int PROPERTY_CHANGED = 0;
    public static final int PROPERTY_ADDED = 1;
    public static final int PROPERTY_REMOVED = 2;
    public static final int PROPERTY_RENAMED = 3;
    public static final int PROPERTIES_REORDERED = 4;
    public static final int TOPIC_FIRED = 5;
    public static final int FLAGS_CHANGED = 6;
    public static final int FACETS_CHANGED = 7;
    public static final int KNOB_ADDED = 8;
    public static final int KNOB_REMOVED = 9;
    public static final int RECATEGORIZED = 10;
    public static final int COMPONENT_PARENTED = 11;
    public static final int COMPONENT_UNPARENTED = 12;
    public static final int COMPONENT_RENAMED = 13;
    public static final int COMPONENT_REORDERED = 14;
    public static final int COMPONENT_FLAGS_CHANGED = 15;
    public static final int COMPONENT_FACETS_CHANGED = 16;
    public static final int RELATION_KNOB_ADDED = 17;
    public static final int RELATION_KNOB_REMOVED = 18;
    public static final int COMPONENT_STARTED = 19;
    public static final int COMPONENT_STOPPED = 20;
    private static String[] ID_STRINGS = new String[]{"changed", "added", "removed", "renamed", "reordered", "topicFired", "flagsChanged", "facetsChanged", "knobAdded", "knobRemoved", "recategorized", "componentParented", "componentUnparented", "componentRenamed", "componentReordered", "componentFlagsChanged", "componentFacetsChanged", "componentKnobAdded", "componentKnobRemoved", "componentStarted", "componentStopped"};
    private static final String[] DISPLAY_STRINGS = new String[]{"property_changed", "property_added", "property_removed", "property_renamed", "property_reordered", "property_topic_fired", "property_flags_changed", "property_facets_changed", "property_knobAdded", "property_knobRemoved", "property_recategorized", "component_parented", "component_unparented", "component_renamed", "component_reordered", "component_flags_changed", "component_facets_changed", "component_knob_added", "component_knob_removed", "component_started", "component_stopped"};
    private int id;
    private String slotName;
    private int slotFlags;
    private BValue value;
    private BComponent component;
    private Slot slot;
    private Knob knob;
    private RelationKnob rknob;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static String[] getIdStrings() {
        return ID_STRINGS;
    }

    public static String[] getDisplayStrings() {
        return DISPLAY_STRINGS;
    }

    public BComponentEvent(int id, BComponent component, Slot slot, BValue value) {
        this.id = id;
        this.component = component;
        if (slot != null) {
            this.slotName = slot.getName();
            this.slotFlags = component.getFlags(slot);
            this.slot = slot;
        }
        if (value != null) {
            this.value = value;
        }
    }

    public BComponentEvent(int id, BComponent component, Knob knob) {
        this.id = id;
        this.component = component;
        this.knob = knob;
        this.slot = knob.getSourceSlot();
        this.slotName = knob.getSourceSlotName();
    }

    public BComponentEvent(int id, BComponent component, RelationKnob rknob) {
        this.id = id;
        this.component = component;
        this.rknob = rknob;
    }

    public BComponentEvent() {
    }

    public int getId() {
        return this.id;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public int getSlotFlags() {
        return this.slotFlags;
    }

    public BValue getValue() {
        return this.value;
    }

    public BComponent getSourceComponent() {
        return this.component;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public RelationKnob getRelationKnob() {
        return this.rknob;
    }

    public Knob getKnob() {
        return this.knob;
    }

    @Override
    public String toString(Context cx) {
        String msg = this.knob != null ? this.knob.toString() : (this.rknob != null ? this.rknob.toString() : '.' + this.slotName + "\": " + this.value);
        return DISPLAY_STRINGS[this.id] + " \"" + (this.component != null ? this.component.toDebugString() : "null") + msg;
    }

    public Object clone() {
        BComponentEvent event = new BComponentEvent();
        event.id = this.id;
        event.slotName = this.slotName;
        event.slotFlags = this.slotFlags;
        event.value = this.value;
        event.component = this.component;
        event.slot = this.slot;
        event.knob = this.knob;
        event.rknob = this.rknob;
        return event;
    }
}

