/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sys;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BBlob
extends BSimple {
    public static final BBlob DEFAULT = new BBlob(new byte[0]);
    public static final Type TYPE = Sys.loadType(BBlob.class);
    byte[] value;
    int hashCode;

    public static BBlob make(byte[] v) {
        return BBlob.make(v, 0, v.length);
    }

    public static BBlob make(byte[] v, int start, int len) {
        if (len == 0) {
            return DEFAULT;
        }
        byte[] value = new byte[len];
        System.arraycopy(v, start, value, 0, len);
        return new BBlob(value);
    }

    private BBlob(byte[] v) {
        this.value = v;
    }

    public int length() {
        return this.value.length;
    }

    public byte byteAt(int index) {
        return this.value[index];
    }

    public void copy(byte[] buf) {
        System.arraycopy(this.value, 0, buf, 0, this.value.length);
    }

    public void copyBytes(int start, byte[] buf, int bufStart, int len) {
        System.arraycopy(this.value, start, buf, bufStart, len);
    }

    public byte[] copyBytes() {
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int h = 31;
            for (byte b : this.value) {
                h = 31 * h + b;
            }
            this.hashCode = h;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BBlob) {
            byte[] me = this.value;
            byte[] him = ((BBlob)obj).value;
            if (me.length != him.length) {
                return false;
            }
            for (int i = 0; i < me.length; ++i) {
                if (me[i] == him[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean bytesEqual(byte[] bytes) {
        return Arrays.equals(this.value, bytes);
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeInt(45323);
        out.writeInt(this.value.length);
        out.write(this.value, 0, this.value.length);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        int magic = in.readInt();
        if (magic != 45323) {
            throw new IOException("Invalid BBlob magic number 0x" + Integer.toHexString(magic));
        }
        int len = in.readInt();
        if (len == 0) {
            return DEFAULT;
        }
        try {
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            return new BBlob(buf);
        }
        catch (OutOfMemoryError e) {
            throw new IOException("Invalid byte array length: " + len);
        }
    }

    @Override
    public String encodeToString() throws IOException {
        return Base64.getEncoder().encodeToString(this.value);
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        return new BBlob(Base64.getDecoder().decode(s));
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

