/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.sync;

import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.AddKnobOp;
import javax.baja.sync.AddOp;
import javax.baja.sync.AddRelationKnobOp;
import javax.baja.sync.FireTopicOp;
import javax.baja.sync.LoadOp;
import javax.baja.sync.RemoveKnobOp;
import javax.baja.sync.RemoveOp;
import javax.baja.sync.RemoveRelationKnobOp;
import javax.baja.sync.RenameOp;
import javax.baja.sync.ReorderOp;
import javax.baja.sync.SetCategoryMaskOp;
import javax.baja.sync.SetFacetsOp;
import javax.baja.sync.SetFlagsOp;
import javax.baja.sync.SetOp;
import javax.baja.sync.SyncBuffer;
import javax.baja.sync.SyncOp;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;

public class ProxyBroker
extends Subscriber
implements NavListener {
    private static final BComponentEventMask PROXY_EVENT_MASK = BComponentEventMask.make(395263);
    private BComponentSpace masterSpace;
    private final Object bufferLock = new BufferLock();
    private ProxySyncBuffer buffer;
    private IProxyBrokerPlugin plugin;
    private static final boolean DEEP_NAV_EVENT_DEPTH = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.proxyBroker.deepNavEvents"));
    private static final int NAV_EVENT_COMPONENT_DEPTH = DEEP_NAV_EVENT_DEPTH ? Integer.MAX_VALUE : 0;
    static final Logger LOG = Logger.getLogger("sys.sync");

    public ProxyBroker(BComponentSpace masterSpace) {
        this.masterSpace = masterSpace;
        this.buffer = new ProxySyncBuffer(masterSpace);
        this.setMask(PROXY_EVENT_MASK);
    }

    public ProxyBroker(BComponentSpace masterSpace, IProxyBrokerPlugin plugin) {
        this(masterSpace);
        this.plugin = plugin;
    }

    public BComponentSpace getMasterSpace() {
        return this.masterSpace;
    }

    public void start() {
        BNavRoot.INSTANCE.addNavListener(this);
    }

    public void stop() {
        BNavRoot.INSTANCE.removeNavListener(this);
        this.unsubscribeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncBuffer detachBuffer() {
        Object object = this.bufferLock;
        synchronized (object) {
            ProxySyncBuffer detached = this.buffer;
            this.buffer = new ProxySyncBuffer(this.masterSpace);
            return detached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOp(BComponent component, int depth) {
        LoadOp op = new LoadOp(component, depth);
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.add(op);
        }
        if (this.plugin != null) {
            this.plugin.newSyncOp(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOp(BComponent component, int depth, boolean partialLoad) {
        LoadOp op = new LoadOp(component, depth, partialLoad);
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.add(op);
        }
        if (this.plugin != null) {
            this.plugin.newSyncOp(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeOp(BComponent component, int depth) {
        this.subscribe(component, depth);
        LoadOp op = new LoadOp(component, depth);
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.add(op);
        }
        if (this.plugin != null) {
            this.plugin.newSyncOp(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeOp(BComponent component, int depth, boolean partialLoad) {
        this.subscribe(component, depth);
        LoadOp op = new LoadOp(component, depth, partialLoad);
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.add(op);
        }
        if (this.plugin != null) {
            this.plugin.newSyncOp(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navEvent(NavEvent event) {
        if (!(event.getParent() instanceof BComponent)) {
            return;
        }
        BComponent component = (BComponent)event.getParent();
        if (component.getComponentSpace() != this.masterSpace) {
            return;
        }
        SyncOp op = null;
        switch (event.getId()) {
            case 1: {
                Property prop = component.getProperty(event.getNewChildName());
                BComponent child = (BComponent)component.get(prop);
                op = new AddOp(component, prop.getName(), child, prop.getDefaultFlags(), prop.getFacets(), NAV_EVENT_COMPONENT_DEPTH);
                break;
            }
            case 2: {
                op = new RemoveOp(component, event.getOldChildName());
                break;
            }
            case 3: {
                op = new RenameOp(component, event.getOldChildName(), event.getNewChildName());
                break;
            }
            case 4: {
                op = new ReorderOp(component, event.getNewOrder());
                break;
            }
            case 5: {
                String childName = event.getOldChildName();
                op = new SetOp(component, childName, null, NAV_EVENT_COMPONENT_DEPTH);
                break;
            }
            case 6: {
                op = new SetCategoryMaskOp(component, event.getNewChildName());
            }
        }
        if (op != null) {
            if (this.plugin == null || this.plugin.isValidSyncOp(op)) {
                Object object = this.bufferLock;
                synchronized (object) {
                    this.buffer.add(op);
                }
            }
            if (this.plugin != null) {
                this.plugin.newSyncOp(op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(BComponentEvent event) {
        BComponent c = event.getSourceComponent();
        if (c.getComponentSpace() != this.masterSpace) {
            throw new IllegalStateException();
        }
        SyncOp op = null;
        switch (event.getId()) {
            case 0: {
                op = new SetOp(c, event.getSlotName(), null);
                break;
            }
            case 1: {
                op = new AddOp(c, event.getSlotName(), event.getValue(), event.getSlotFlags(), event.getSlot().getFacets());
                break;
            }
            case 2: {
                op = new RemoveOp(c, event.getSlotName());
                break;
            }
            case 3: {
                op = new RenameOp(c, event.getValue().toString(), event.getSlotName());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                op = new FireTopicOp(c, event.getSlotName(), event.getValue());
                break;
            }
            case 6: {
                op = new SetFlagsOp(c, event.getSlotName(), event.getSlotFlags());
                break;
            }
            case 7: {
                op = new SetFacetsOp(c, event.getSlotName(), (BFacets)event.getValue());
                break;
            }
            case 10: {
                break;
            }
            case 8: {
                op = new AddKnobOp(c, event.getKnob());
                break;
            }
            case 9: {
                op = new RemoveKnobOp(c, event.getKnob());
                break;
            }
            case 17: {
                op = new AddRelationKnobOp(c, event.getRelationKnob());
                break;
            }
            case 18: {
                op = new RemoveRelationKnobOp(c, event.getRelationKnob());
            }
        }
        if (op != null) {
            if (this.plugin == null || this.plugin.isValidSyncOp(op)) {
                Object object = this.bufferLock;
                synchronized (object) {
                    this.buffer.add(op);
                }
            }
            if (this.plugin != null) {
                this.plugin.newSyncOp(op);
            }
        }
    }

    static {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ProxyBroker is currently set to " + (DEEP_NAV_EVENT_DEPTH ? "" : "not ") + "send deep nav events.");
        }
    }

    public static interface IProxyBrokerPlugin {
        default public boolean isValidSyncOp(SyncOp op) {
            return true;
        }

        public void newSyncOp(SyncOp var1);
    }

    static class BufferLock {
        BufferLock() {
        }
    }

    class ProxySyncBuffer
    extends SyncBuffer {
        ProxySyncBuffer(BComponentSpace space) {
            super(space, true);
        }
    }
}

