/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security.dashboard;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Type;

public class LexiconFormatInfo {
    protected final String moduleName;
    protected final String key;

    protected LexiconFormatInfo(String moduleName, String key) {
        this.moduleName = moduleName;
        this.key = key;
    }

    public static LexiconFormatInfo make(String moduleName, String key) {
        return new LexiconFormatInfo(moduleName, key);
    }

    public static LexiconFormatInfo make(String moduleName, String key, List<? extends BSimple> formatArgs) {
        return new LexiconFormatInfoWithArgs(moduleName, key, formatArgs);
    }

    public static LexiconFormatInfo make(String moduleName, String key, BSimple ... formatArgs) {
        return formatArgs == null || formatArgs.length <= 0 ? LexiconFormatInfo.make(moduleName, key) : LexiconFormatInfo.make(moduleName, key, Arrays.asList(formatArgs));
    }

    public static LexiconFormatInfo make(Type type, String key) {
        return new LexiconFormatInfo(type.getModule().getModuleName(), key);
    }

    public static LexiconFormatInfo make(Type type, String key, List<? extends BSimple> formatArgs) {
        return new LexiconFormatInfoWithArgs(type.getModule().getModuleName(), key, formatArgs);
    }

    public static LexiconFormatInfo make(Type type, String key, BSimple ... formatArgs) {
        return formatArgs == null || formatArgs.length <= 0 ? LexiconFormatInfo.make(type, key) : LexiconFormatInfo.make(type, key, Arrays.asList(formatArgs));
    }

    public static LexiconFormatInfo make(Type type, String key, boolean arg) {
        return LexiconFormatInfo.make(type, key, BBoolean.make(arg));
    }

    public static LexiconFormatInfo make(Type type, String key, double arg) {
        return LexiconFormatInfo.make(type, key, BDouble.make(arg));
    }

    public static LexiconFormatInfo make(Type type, String key, float arg) {
        return LexiconFormatInfo.make(type, key, BFloat.make(arg));
    }

    public static LexiconFormatInfo make(Type type, String key, int arg) {
        return LexiconFormatInfo.make(type, key, BInteger.make(arg));
    }

    public static LexiconFormatInfo make(Type type, String key, long arg) {
        return LexiconFormatInfo.make(type, key, BLong.make(arg));
    }

    public static LexiconFormatInfo make(Type type, String key, String arg) {
        return LexiconFormatInfo.make(type, key, BString.make(arg));
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getKey() {
        return this.key;
    }

    public List<? extends BSimple> getFormatArgs() {
        return Collections.emptyList();
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("lexiconKey", (Object)(this.moduleName + ':' + this.key));
        List<? extends BSimple> formatArgs = this.getFormatArgs();
        if (!formatArgs.isEmpty()) {
            json.put("arguments", (Object)LexiconFormatInfo.formatArgsToJSON(formatArgs));
        }
        return json;
    }

    private static JSONArray formatArgsToJSON(List<? extends BSimple> formatArgs) {
        JSONArray jsonArray = new JSONArray();
        for (BSimple bSimple : formatArgs) {
            JSONObject jsonArg = new JSONObject();
            if (!(bSimple instanceof BString)) {
                jsonArg.put("type", (Object)bSimple.getType());
            }
            String value = "";
            try {
                value = bSimple.encodeToString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            jsonArg.put("value", (Object)value);
            jsonArray.put((Object)jsonArg);
        }
        return jsonArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LexiconFormatInfo that = (LexiconFormatInfo)o;
        return Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.key);
    }

    public String toString() {
        return "LexiconFormatInfo{moduleName='" + this.moduleName + '\'' + ", key='" + this.key + '\'' + '}';
    }

    private static final class LexiconFormatInfoWithArgs
    extends LexiconFormatInfo {
        private final List<? extends BSimple> formatArgs;

        protected LexiconFormatInfoWithArgs(String moduleName, String key, List<? extends BSimple> formatArgs) {
            super(moduleName, key);
            this.formatArgs = Collections.unmodifiableList(formatArgs);
        }

        @Override
        public List<? extends BSimple> getFormatArgs() {
            return this.formatArgs;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LexiconFormatInfoWithArgs that = (LexiconFormatInfoWithArgs)o;
            if (this.formatArgs.size() != that.formatArgs.size()) {
                return false;
            }
            for (int i = 0; i < this.formatArgs.size(); ++i) {
                if (this.formatArgs.get(i).equivalent(that.formatArgs.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.formatArgs);
        }

        @Override
        public String toString() {
            return "LexiconFormatInfoWithArgs{moduleName='" + this.moduleName + '\'' + ", key='" + this.key + '\'' + ", formatArgs=" + this.formatArgs + '}';
        }
    }
}

