/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NX509Certificate;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import javax.security.auth.x500.X500Principal;

@NiagaraType
public final class BX509Certificate
extends BSimple {
    public static final BX509Certificate DEFAULT = new BX509Certificate(null);
    public static final Type TYPE = Sys.loadType(BX509Certificate.class);
    private X509Certificate cert;

    public static BX509Certificate make(X509Certificate cert) {
        return new BX509Certificate(cert);
    }

    public static BX509Certificate make(String encoded) {
        if (encoded == null || encoded.isEmpty()) {
            return BX509Certificate.make((X509Certificate)null);
        }
        try {
            return BX509Certificate.make(CertUtils.decodeX509Certificate((String)encoded));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid source provided", e);
        }
    }

    private BX509Certificate(X509Certificate cert) {
        this.cert = cert;
    }

    public X509Certificate getX509Certificate() {
        return this.cert;
    }

    public String getUsername() {
        return BX509Certificate.extractUserName(this.cert);
    }

    public static String extractUserName(X509Certificate cert) {
        return NX509Certificate.extractCommonName((X500Principal)cert.getSubjectX500Principal());
    }

    @Override
    public boolean isNull() {
        return this.cert == null;
    }

    @Override
    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput decoder) throws IOException {
        return this.decodeFromString(decoder.readUTF());
    }

    @Override
    public String encodeToString() throws IOException {
        if (this.cert == null) {
            return "";
        }
        try {
            return CertUtils.encodeX509Certificate((X509Certificate)this.cert);
        }
        catch (Exception e) {
            throw new IOException("invalid source provided", e);
        }
    }

    @Override
    public BObject decodeFromString(String s) throws IOException {
        try {
            return BX509Certificate.make(s);
        }
        catch (Exception e) {
            throw new IOException("invalid source provided", e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof BX509Certificate) {
            BX509Certificate other = (BX509Certificate)obj;
            return Objects.equals(this.cert, other.cert);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.cert != null ? this.cert.hashCode() : 0;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static String getSubjectDn(String certificate, Context context) throws LocalizableException {
        if (certificate == null || certificate.isEmpty()) {
            return LexiconModule.make("baja").get("x509Certificate.noCertificate", context);
        }
        try {
            return BX509Certificate.make(certificate).getX509Certificate().getSubjectX500Principal().toString();
        }
        catch (Exception e) {
            throw new LocalizableException("baja", "x509Certificate.getSubjectDn.error", e);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

