/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BICredentials;
import javax.baja.security.BIExtraAttributesCredentials;
import javax.baja.security.BUsernameCredential;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="scheme", type="BString", defaultValue="")
public class BUsernameSchemeCredentials
extends BUsernameCredential
implements BIExtraAttributesCredentials {
    @Generated
    public static final Property scheme = BUsernameSchemeCredentials.newProperty(0, "", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUsernameSchemeCredentials.class);

    @Generated
    public String getScheme() {
        return this.getString(scheme);
    }

    @Generated
    public void setScheme(String v) {
        this.setString(scheme, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUsernameSchemeCredentials() {
    }

    public BUsernameSchemeCredentials(String username, String scheme) {
        super(username);
        this.setScheme(scheme);
    }

    @Override
    public byte[] encodeCredentials(Context context) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        BString.make(this.getUsername()).encode(out);
        BString.make(this.getScheme()).encode(out);
        out.flush();
        return bout.toByteArray();
    }

    @Override
    public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
        DataInputStream in = new DataInputStream(bin);
        BUsernameSchemeCredentials x = (BUsernameSchemeCredentials)this.newCopy();
        x.set(username, (BValue)BString.DEFAULT.decode(in));
        x.set(scheme, (BValue)BString.DEFAULT.decode(in));
        return x;
    }

    @Override
    public synchronized boolean equivalent(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && Objects.equals(((BUsernameSchemeCredentials)obj).getUsername(), this.getUsername()) && Objects.equals(((BUsernameSchemeCredentials)obj).getScheme(), this.getScheme());
    }

    @Override
    public Map<String, Object> getExtraAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("scheme", this.getScheme());
        return attributes;
    }
}

