/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BNavFileSpace
extends BSpace {
    @Generated
    public static final Type TYPE = Sys.loadType(BNavFileSpace.class);
    BNavFileNode root;
    Map<BOrd, BINavNode> map = new HashMap<BOrd, BINavNode>();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNavFileSpace(BNavFileNode root) {
        super("navfile", null);
        this.root = root;
        this.addNavChild(root);
        this.buildMap(root);
    }

    void buildMap(BINavNode node) {
        BOrd ord = node.getNavOrd();
        this.map.put(ord, node);
        BINavNode[] kids = node.getNavChildren();
        for (int i = 0; i < kids.length; ++i) {
            this.buildMap(kids[i]);
        }
    }

    public BNavFileNode getRootNode() {
        return this.root;
    }

    public BNavFileNode lookup(BOrd ord) {
        BNavFileNode node = (BNavFileNode)this.map.get(ord);
        if (node != null) {
            return node;
        }
        OrdQuery[] q = ord.parse();
        if (q.length > 0 && q[q.length - 1] instanceof ViewQuery && (node = (BNavFileNode)this.map.get(ord = BOrd.make(q, 0, q.length - 1))) != null) {
            return node;
        }
        return null;
    }

    @Override
    public BOrd getOrdInSession() {
        return BOrd.make("dummy:");
    }

    @Override
    public String getNavDisplayName(Context cx) {
        if (this.root == null) {
            return super.getNavDisplayName(cx);
        }
        return this.root.getNavDisplayName(cx);
    }

    @Override
    public String getNavDescription(Context cx) {
        return Lexicon.make("baja", cx).getText("nav.navFileSpace.description");
    }

    @Override
    public boolean hasNavChildren() {
        return this.root != null;
    }

    @Override
    public BINavNode getNavChild(String name) {
        if (this.root == null) {
            return null;
        }
        return this.root.getNavChild(name);
    }

    @Override
    public BINavNode[] getNavChildren() {
        if (this.root == null) {
            return new BINavNode[0];
        }
        return this.root.getNavChildren();
    }

    @Override
    public BIcon getNavIcon() {
        if (this.root == null) {
            return this.getIcon();
        }
        return this.root.getNavIcon();
    }

    @Override
    public BOrd getNavOrd() {
        if (this.root == null) {
            return super.getNavOrd();
        }
        return this.root.getNavOrd();
    }
}

