/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.nav;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInterface;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public interface BINavNode
extends BInterface {
    @Generated
    public static final Type TYPE = Sys.loadType(BINavNode.class);

    public String getNavName();

    public String getNavDisplayName(Context var1);

    public String getNavDescription(Context var1);

    public BINavNode getNavParent();

    public boolean hasNavChildren();

    public BINavNode getNavChild(String var1);

    public BINavNode resolveNavChild(String var1);

    public BINavNode[] getNavChildren();

    public BOrd getNavOrd();

    public BIcon getNavIcon();

    default public Iterator<BINavNode> iterateNavDescendants() {
        if (this.hasNavChildren()) {
            return new NavDescendantsIterator(this);
        }
        return Collections.emptyIterator();
    }

    public static class NavDescendantsIterator
    implements Iterator<BINavNode> {
        private final BINavNode[] navChildren;
        private int childIndex = 0;
        private int iteratorIndex = 0;
        private Iterator<BINavNode> childIterator = Collections.emptyIterator();

        public NavDescendantsIterator(BINavNode root) {
            this.navChildren = root.hasNavChildren() ? root.getNavChildren() : null;
        }

        @Override
        public boolean hasNext() {
            if (this.navChildren == null) {
                return false;
            }
            if (this.childIndex < this.navChildren.length) {
                return true;
            }
            while (this.childIterator != null && !this.childIterator.hasNext()) {
                if (this.iteratorIndex < this.navChildren.length) {
                    this.childIterator = this.navChildren[this.iteratorIndex].iterateNavDescendants();
                    ++this.iteratorIndex;
                    continue;
                }
                this.childIterator = null;
            }
            return this.childIterator != null;
        }

        @Override
        public BINavNode next() throws NoSuchElementException {
            if (this.navChildren == null) {
                throw new NoSuchElementException();
            }
            if (this.childIndex < this.navChildren.length) {
                ++this.childIndex;
                return this.navChildren[this.childIndex - 1];
            }
            if (this.childIterator == null) {
                throw new NoSuchElementException();
            }
            return this.childIterator.next();
        }
    }
}

