/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.baja.nre.util.TextUtil;
import javax.baja.xml.XException;
import javax.baja.xml.XWriter;
import org.owasp.encoder.Encode;

public class HtmlWriter
extends PrintWriter {
    public HtmlWriter(Writer out) {
        super(out);
    }

    public HtmlWriter(OutputStream out) {
        super(out);
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.print('\n');
        this.flush();
    }

    public HtmlWriter w(Object o) {
        this.print(o);
        return this;
    }

    public final HtmlWriter w(boolean b) {
        this.print(b);
        return this;
    }

    public final HtmlWriter w(char c) {
        this.print(c);
        return this;
    }

    public final HtmlWriter w(int i) {
        this.print(i);
        return this;
    }

    public final HtmlWriter w(long l) {
        this.print(l);
        return this;
    }

    public final HtmlWriter w(float f) {
        this.print(f);
        return this;
    }

    public final HtmlWriter w(double d) {
        this.print(d);
        return this;
    }

    public final HtmlWriter nbsp() {
        this.print("&nbsp;");
        return this;
    }

    public final HtmlWriter nl() {
        this.print('\n');
        return this;
    }

    public final HtmlWriter indent(int indent) {
        return this.w(TextUtil.getSpaces((int)indent));
    }

    public final HtmlWriter attr(String name, String value) {
        return this.w(name).w('=').w('\'').safe(value).w('\'');
    }

    public final HtmlWriter attr(String name, int value) {
        return this.attr(name, Integer.toString(value));
    }

    public final HtmlWriter attr(String name, float value) {
        return this.attr(name, Float.toString(value));
    }

    public final HtmlWriter attr(String name, double value) {
        return this.attr(name, Double.toString(value));
    }

    public final HtmlWriter attr(String name, Object value) {
        return this.attr(name, String.valueOf(value));
    }

    public final HtmlWriter safe(String s, boolean escapeWhitespace) {
        try {
            XWriter.safe((Writer)this, (String)s, (boolean)escapeWhitespace);
            return this;
        }
        catch (IOException e) {
            throw new XException(e.toString(), (Throwable)e);
        }
    }

    public final HtmlWriter safe(Object s) {
        try {
            XWriter.safe((Writer)this, (String)String.valueOf(s), (boolean)true);
            return this;
        }
        catch (IOException e) {
            throw new XException(e.toString(), (Throwable)e);
        }
    }

    public final HtmlWriter safe(int c, boolean escapeWhitespace) {
        try {
            XWriter.safe((Writer)this, (int)c, (boolean)escapeWhitespace);
            return this;
        }
        catch (IOException e) {
            throw new XException(e.toString(), (Throwable)e);
        }
    }

    public String href(String href) {
        return href;
    }

    public HtmlWriter a(String href, Object body) {
        return this.w(this.createLink(href, body));
    }

    public String createLink(String href, Object body) {
        return "<a href='" + this.href(href) + "'>" + Encode.forHtml((String)String.valueOf(body)) + "</a>";
    }

    public HtmlWriter a(String href) {
        return this.a(href, href);
    }

    public HtmlWriter startTable(boolean border) {
        this.w("<table");
        if (border) {
            this.w(" border='1' cellspacing='0'");
        }
        this.w(">\n");
        return this;
    }

    public HtmlWriter trTitle(Object title, int colspan) {
        return this.tr().w("<th nowrap='true' colspan='").w(colspan).w("' bgcolor='#d0d0d0'>").w(title).endTh().endTr();
    }

    public HtmlWriter thTitle(Object title) {
        return this.thTitle().w(title).endTh();
    }

    public HtmlWriter endTable() {
        return this.w("</table>\n");
    }

    public HtmlWriter tr(Object c0) {
        return this.tr().td(c0).endTr();
    }

    public HtmlWriter tr(Object c0, Object c1) {
        return this.tr().td(c0).td(c1).endTr();
    }

    public HtmlWriter tr(Object c0, Object c1, Object c2) {
        return this.tr().td(c0).td(c1).td(c2).endTr();
    }

    public HtmlWriter tr(Object c0, Object c1, Object c2, Object c3) {
        return this.tr().td(c0).td(c1).td(c2).td(c3).endTr();
    }

    public HtmlWriter tr(Object c0, Object c1, Object c2, Object c3, Object c4) {
        return this.tr().td(c0).td(c1).td(c2).td(c3).td(c4).endTr();
    }

    public HtmlWriter tr(Object c0, Object c1, Object c2, Object c3, Object c4, Object c5) {
        return this.tr().td(c0).td(c1).td(c2).td(c3).td(c4).td(c5).endTr();
    }

    public HtmlWriter tr(Object c0, Object c1, Object c2, Object c3, Object c4, Object c5, Object c6) {
        return this.tr().td(c0).td(c1).td(c2).td(c3).td(c4).td(c5).td(c6).endTr();
    }

    public HtmlWriter th(Object s) {
        return this.th().w(s).endTh();
    }

    public HtmlWriter td(Object s) {
        return this.td().w(s).endTd();
    }

    public HtmlWriter thTitle() {
        return this.w("<th align='left' nowrap='true' bgcolor='#d0d0d0'>");
    }

    public HtmlWriter th() {
        return this.w("<th align='left' nowrap='true'>");
    }

    public HtmlWriter endTh() {
        return this.w("</th>\n");
    }

    public HtmlWriter tr() {
        return this.w("<tr>");
    }

    public HtmlWriter endTr() {
        return this.w("</tr>\n");
    }

    public HtmlWriter td() {
        return this.w("<td align='left' nowrap='true'>");
    }

    public HtmlWriter endTd() {
        return this.w("</td>");
    }
}

