/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.firewall;

import com.tridium.firewall.ConcurrentFirewallProcessor;
import com.tridium.firewall.FirewallRulesPage;
import com.tridium.nre.firewall.FirewallProcessor;
import com.tridium.nre.firewall.FirewallRule;
import com.tridium.nre.firewall.IpProtocol;
import com.tridium.nre.firewall.NullFirewallProcessor;
import com.tridium.nre.firewall.RedirectRule;
import com.tridium.nre.firewall.pf.InvalidRuleException;
import com.tridium.nre.firewall.pf.PfFirewallProcessor;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.firewall.BIpProtocolEnum;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.Spy;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIUnlinkableSlotsContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="publicServerPort", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="65535"), @Facet(name="BFacets.RADIX", value="10")}), @NiagaraProperty(name="localServerPort", type="int", defaultValue="0", flags=4, facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="65535"), @Facet(name="BFacets.RADIX", value="10")}), @NiagaraProperty(name="ipProtocol", type="BIpProtocolEnum", defaultValue="BIpProtocolEnum.tcp", flags=1), @NiagaraProperty(name="adapter", type="String", defaultValue="any", flags=5)})
public class BServerPort
extends BComponent
implements BIUnlinkableSlotsContainer {
    @Generated
    public static final Property publicServerPort = BServerPort.newProperty(0, 0, BFacets.make(BFacets.make(BFacets.make("min", 1), BFacets.make("max", 65535)), BFacets.make("radix", 10)));
    @Generated
    public static final Property localServerPort = BServerPort.newProperty(4, 0, BFacets.make(BFacets.make(BFacets.make("min", 0), BFacets.make("max", 65535)), BFacets.make("radix", 10)));
    @Generated
    public static final Property ipProtocol = BServerPort.newProperty(1, BIpProtocolEnum.tcp, null);
    @Generated
    public static final Property adapter = BServerPort.newProperty(5, "any", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BServerPort.class);
    private RedirectRule last = null;
    private final Object mutex = new Object();
    private static final Set<Slot> UNLINKABLE_TARGET_SLOTS = Collections.unmodifiableSet(Stream.of(publicServerPort, localServerPort).collect(Collectors.toSet()));
    private boolean bindToLoopback = false;
    private int bindingPort = 0;
    public static final String LOCALHOST_INTERFACE = "127.0.0.1";
    private static final String BSERVER_PORT_FACET_KEY = "BServerPort";
    private static final String BSERVER_PORT_FACET_VALUE = "alreadyProcessed";

    @Generated
    public int getPublicServerPort() {
        return this.getInt(publicServerPort);
    }

    @Generated
    public void setPublicServerPort(int v) {
        this.setInt(publicServerPort, v, null);
    }

    @Generated
    public int getLocalServerPort() {
        return this.getInt(localServerPort);
    }

    @Generated
    public void setLocalServerPort(int v) {
        this.setInt(localServerPort, v, null);
    }

    @Generated
    public BIpProtocolEnum getIpProtocol() {
        return (BIpProtocolEnum)this.get(ipProtocol);
    }

    @Generated
    public void setIpProtocol(BIpProtocolEnum v) {
        this.set(ipProtocol, (BValue)v, null);
    }

    @Generated
    public String getAdapter() {
        return this.getString(adapter);
    }

    @Generated
    public void setAdapter(String v) {
        this.setString(adapter, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BServerPort() {
    }

    public BServerPort(int publicServerPort) {
        this.setPublicServerPort(publicServerPort);
    }

    public BServerPort(int publicServerPort, IpProtocol protocol) {
        this(publicServerPort);
        this.setIpProtocol(BIpProtocolEnum.make(protocol.name().toLowerCase()));
    }

    public BServerPort(int publicServerPort, int localServerPort, IpProtocol protocol) {
        this(publicServerPort);
        this.setLocalServerPort(localServerPort);
        this.setIpProtocol(BIpProtocolEnum.make(protocol.name().toLowerCase()));
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.updateFirewallRules();
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
        this.removeFirewallRules();
    }

    @Override
    public void changed(Property property, Context context) {
        BObject processedStateFacet;
        super.changed(property, context);
        if (!(!this.isRunning() || context == null || (processedStateFacet = context.getFacet(BSERVER_PORT_FACET_KEY)) != null && processedStateFacet instanceof BString && ((BString)processedStateFacet).getString().equals(BSERVER_PORT_FACET_VALUE) || property != publicServerPort && property != localServerPort && property != adapter && property != ipProtocol)) {
            this.updateFirewallRules();
            BasicContext newContext = new BasicContext(context, BFacets.make(BSERVER_PORT_FACET_KEY, BSERVER_PORT_FACET_VALUE));
            Property prop = this.getPropertyInParent();
            this.getParent().getParentComponent().changed(prop, newContext);
        }
    }

    public boolean getBindToLoopback() {
        return this.bindToLoopback;
    }

    public int getBindingPort() {
        this.updateFirewallRules();
        return this.bindingPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFirewallRules() {
        Object object = this.mutex;
        synchronized (object) {
            RedirectRule rule = new RedirectRule(this.getPublicServerPort(), this.getLocalServerPort(), BIpProtocolEnum.make(this.getIpProtocol()), this.getAdapter());
            try {
                rule = BServerPort.fw().validateRule((FirewallRule)rule);
                if (rule.equivalentTo((FirewallRule)this.last)) {
                    return;
                }
            }
            catch (InvalidRuleException e) {
                Logger.getLogger("firewall").severe("invalid rule provided, rule ignored: " + e.getLocalizedMessage());
                return;
            }
            if (this.last != null) {
                BServerPort.fw().removeRule((FirewallRule)this.last);
            }
            try {
                this.last = (RedirectRule)BServerPort.fw().addRule((FirewallRule)rule);
                this.bindingPort = this.last.getLocalServerPort();
                this.bindToLoopback = this.last.getBindToLoopback();
            }
            catch (InvalidRuleException e) {
                this.last = null;
            }
            BServerPort.fw().processRules();
        }
    }

    private void removeFirewallRules() {
        if (this.last != null) {
            BServerPort.fw().removeRule((FirewallRule)this.last);
            this.last = null;
            BServerPort.fw().processRules();
        }
    }

    @Override
    public String toString(Context context) {
        return String.format("%d %s", this.getPublicServerPort(), this.getIpProtocol().getTag());
    }

    public static FirewallRule[] getRuleList() {
        return BServerPort.fw().getRulesList();
    }

    public static String getFirewallName() {
        return BServerPort.fw().getFirewallName();
    }

    public static String getFirewallDescription() {
        return BServerPort.fw().getDescription();
    }

    private static FirewallProcessor fw() {
        return FirewallHolder.fw;
    }

    @Override
    public final Set<Slot> getUnlinkableTargetSlots(Context context) {
        return UNLINKABLE_TARGET_SLOTS;
    }

    private static final class FirewallHolder {
        private static FirewallProcessor fw;

        private FirewallHolder() {
        }

        static {
            boolean useQnxPfctl = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.qnx.pfctl.enabled"));
            if (useQnxPfctl) {
                String pfctlPath = AccessController.doPrivileged(() -> System.getProperty("niagara.qnx.pfctl.path"));
                String pfConfFile = AccessController.doPrivileged(() -> System.getProperty("niagara.qnx.pfctl.file"));
                fw = new ConcurrentFirewallProcessor((FirewallProcessor)new PfFirewallProcessor(pfctlPath, pfConfFile));
                Logger firewallLog = Logger.getLogger("firewall");
                if (firewallLog.isLoggable(Level.FINER)) {
                    firewallLog.finer("setting firewall implementation to PfFirewallProcessor");
                    firewallLog.finer("pfctl.path=" + pfctlPath);
                    firewallLog.finer("pfctl.file=" + pfConfFile);
                }
            } else {
                fw = new ConcurrentFirewallProcessor((FirewallProcessor)new NullFirewallProcessor());
                Logger.getLogger("firewall").finer("setting firewall implementation to NullFirewallProcessor");
            }
            Spy.ROOT.add("Firewall Rules", new FirewallRulesPage());
        }
    }
}

