/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BMemoryFileStore
extends BAbstractFileStore {
    @Generated
    public static final Type TYPE = Sys.loadType(BMemoryFileStore.class);
    BAbsTime lastModified = BAbsTime.now();
    ByteBuffer buffer = new ByteBuffer();
    BIFile f = null;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMemoryFileStore(BFileSpace space, FilePath path) {
        super(space, path);
    }

    public void setFile(BIFile f) {
        this.f = f;
    }

    public BIFile getFile() {
        return this.f;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    @Override
    public long getSize() {
        return this.buffer.getLength();
    }

    @Override
    public BAbsTime getLastModified() {
        return this.lastModified;
    }

    @Override
    public byte[] read() throws IOException {
        return this.buffer.toByteArray();
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.read());
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        this.lastModified = BAbsTime.make();
        this.buffer = new ByteBuffer();
        return this.buffer.getOutputStream();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

