/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
public abstract class BLocalizedFileSpace
extends BFileSpace {
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalizedFileSpace.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLocalizedFileSpace(String name, LexiconText lexText) {
        super(name, lexText);
    }

    public BLocalizedFileSpace(String name) {
        super(name);
    }

    public abstract boolean isNiagaraHomeReadOnly();

    private boolean redirectToNiagaraUserHome(FilePath path) {
        if (path == null || !this.isNiagaraHomeReadOnly() || !path.isSysHomeAbsolute() || path.depth() < 1) {
            return false;
        }
        String directory = path.nameAt(0);
        if ("modules".equals(directory)) {
            return true;
        }
        return "security".equals(directory);
    }

    protected FilePath getLocalizedFilePath(FilePath path) {
        return this.redirectToNiagaraUserHome(path) ? this.switchToUserHome(path) : path;
    }

    private FilePath switchToUserHome(FilePath path) {
        String body = path.getBody();
        if (body != null && !body.isEmpty() && body.charAt(0) == '!') {
            return new FilePath("~" + body.substring(1));
        }
        return path;
    }

    @Override
    public BIFile findFile(FilePath path) {
        return super.findFile(this.getLocalizedFilePath(path));
    }

    @Override
    public BIFile resolveFile(FilePath path) {
        return super.resolveFile(this.getLocalizedFilePath(path));
    }
}

