/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.collection;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import javax.baja.collection.SlotCursorIterator;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;

public class ValueCollection
implements Collection<BValue> {
    private BComplex obj;

    public ValueCollection(BComplex obj) {
        this.obj = obj;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof BValue)) {
            return false;
        }
        SlotCursor<Property> c = this.obj.getProperties();
        while (c.next()) {
            if (!c.get().equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ValueCollection) {
            return ((ValueCollection)o).obj == this.obj;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.obj.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.obj.getPropertyCount() == 0;
    }

    @Override
    public int size() {
        return this.obj.getPropertyCount();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new BValue[this.size()];
        SlotCursor<Property> c = this.obj.getProperties();
        int index = 0;
        while (c.next()) {
            result[index++] = c.get();
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (BValue.class.isAssignableFrom(a.getClass().getComponentType())) {
            try {
                T[] result = this.size() == a.length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
                SlotCursor<Property> c = this.obj.getProperties();
                int index = 0;
                while (c.next()) {
                    result[index++] = c.get();
                }
                return result;
            }
            catch (ClassCastException ex) {
                throw new ArrayStoreException();
            }
        }
        throw new ArrayStoreException();
    }

    @Override
    public Iterator<BValue> iterator() {
        return SlotCursorIterator.iterator(this.obj.getProperties());
    }

    @Override
    public boolean add(BValue p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends BValue> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }
}

