/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.collection;

import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;

public class SlotCursorIterator<T extends BValue>
implements Iterator<T> {
    private final Iterator<T> iterator;

    public SlotCursorIterator(SlotCursor<Property> cursor, Class<T> filterClass) {
        this.iterator = SlotCursorIterator.stream(cursor, filterClass).iterator();
    }

    @Deprecated
    public SlotCursorIterator(SlotCursor<Property> cursor) {
        this.iterator = SlotCursorIterator.stream(cursor, BValue.class).map(v -> v).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return (T)((BValue)this.iterator.next());
    }

    public static Iterator<BValue> iterator(SlotCursor<Property> cursor) {
        Stream<BValue> s = SlotCursorIterator.stream(cursor);
        return s.iterator();
    }

    public static <T> Iterator<T> iterator(SlotCursor<Property> cursor, Class<T> filterClass) {
        Stream<T> s = SlotCursorIterator.stream(cursor, filterClass);
        return s.iterator();
    }

    public static Stream<BValue> stream(SlotCursor<Property> cursor) {
        return SlotCursorIterator.stream(cursor, BValue.class);
    }

    public static <T> Stream<T> stream(final SlotCursor<Property> cursor, final Class<T> filterClass) {
        Objects.requireNonNull(cursor);
        Objects.requireNonNull(filterClass);
        final boolean shouldFilter = filterClass != BValue.class;
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(0L, 256){

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                boolean next = shouldFilter ? cursor.next(filterClass) : cursor.next();
                if (next) {
                    consumer.accept(cursor.get());
                }
                return next;
            }
        }, false);
    }
}

