/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.category;

import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.util.CategoryValidator;
import com.tridium.util.HistoryCategoryUtil;
import com.tridium.util.PxUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.agent.AgentList;
import javax.baja.category.BAbstractCategory;
import javax.baja.category.BCategory;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.role.BIRole;
import javax.baja.role.BRoleService;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.virtual.BVirtualComponent;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ordMap", type="BOrdToCategoryMap", defaultValue="BOrdToCategoryMap.NULL", flags=5), @NiagaraProperty(name="updatePeriod", type="BRelTime", defaultValue="BRelTime.make(60000L)")})
@NiagaraAction(name="update")
public final class BCategoryService
extends BComponent
implements BIService,
BIRestrictedComponent {
    @Generated
    public static final Property ordMap = BCategoryService.newProperty(5, BOrdToCategoryMap.NULL, null);
    @Generated
    public static final Property updatePeriod = BCategoryService.newProperty(0, BRelTime.make(60000L), null);
    @Generated
    public static final Action update = BCategoryService.newAction(0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCategoryService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std("navOnly/categoryService.png");
    static final BCategoryMask DEFAULT_MASK = BCategoryMask.make("1");
    private static final BOrd[] EMPTY_ORDS = new BOrd[0];
    private static final BCategoryMask[] EMPTY_MASKS = new BCategoryMask[0];
    private static final Logger LOG = Logger.getLogger("sys.service");
    BCategory[] lookup;
    UpdateThread thread;
    long lastUpdateTicks;
    long lastUpdateDuration;

    @Generated
    public BOrdToCategoryMap getOrdMap() {
        return (BOrdToCategoryMap)this.get(ordMap);
    }

    @Generated
    public void setOrdMap(BOrdToCategoryMap v) {
        this.set(ordMap, (BValue)v, null);
    }

    @Generated
    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    @Generated
    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    @Generated
    public void update() {
        this.invoke(update, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BCategoryService getService() {
        return (BCategoryService)Sys.getService(TYPE);
    }

    public BCategory[] getCategories() {
        return this.getChildren(BCategory.class);
    }

    public int getMaxCategoryIndex() {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        for (int i = this.lookup.length - 1; i > 0; --i) {
            if (this.lookup[i] == null) continue;
            return i;
        }
        return 0;
    }

    public BCategory getCategory(int index) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        if (index >= this.lookup.length) {
            return null;
        }
        return this.lookup[index];
    }

    public BCategory[] getCategories(BCategoryMask mask) {
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        int size = Math.min(mask.size(), this.lookup.length) + 1;
        Array acc = new Array(BCategory.class, size);
        for (int i = 1; i < size; ++i) {
            if (!mask.get(i) || this.lookup[i] == null) continue;
            acc.add((Object)this.lookup[i]);
        }
        return (BCategory[])acc.trim();
    }

    public BCategoryMask getCategoryMask(BOrd ord) {
        BCategoryMask mask;
        if (ord != null && !ord.isNull() && (mask = this.getOrdMap().getCategoryMask(ord)) != null) {
            return mask;
        }
        return DEFAULT_MASK;
    }

    public BCategoryMask getAppliedCategoryMask(BOrd ord) {
        BCategoryMask mask;
        if (ord != null && !ord.isNull() && (mask = this.getOrdMap().getAppliedCategoryMask(ord)) != null) {
            return mask;
        }
        return DEFAULT_MASK;
    }

    public static BOrd getCategorizableOrd(BINavNode node, Context cx) {
        return node instanceof BVirtualComponent ? ((BVirtualComponent)node).getCategorizableOrd() : node.getNavOrd();
    }

    @Override
    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    private void convertLegacyOrdsInMap() {
        BOrdToCategoryMap oMap = this.getOrdMap();
        ArrayList<String> origOrdStrings = new ArrayList<String>(oMap.size());
        ArrayList<BOrd> newOrds = new ArrayList<BOrd>(oMap.size());
        ArrayList<BCategoryMask> cats = new ArrayList<BCategoryMask>(oMap.size());
        for (int i = 0; i < oMap.size(); ++i) {
            BOrd ord = oMap.getOrd(i);
            String origOrdStr = ord.relativizeToSession().encodeToString();
            boolean caseSensitive = HistoryCategoryUtil.isCaseSensitiveInOrdToCategoryMap(origOrdStr);
            if (caseSensitive) {
                origOrdStrings.add(origOrdStr);
                newOrds.add(ord);
                cats.add(oMap.getCategoryMask(i));
                continue;
            }
            String lowerCaseOrdStr = TextUtil.toLowerCase((String)origOrdStr);
            boolean origOrdIsLowercase = origOrdStr.equals(lowerCaseOrdStr);
            BOrd lowerCaseOrd = BOrd.make(lowerCaseOrdStr);
            int idxOfDuplicate = newOrds.indexOf(lowerCaseOrd);
            if (!origOrdIsLowercase && idxOfDuplicate >= 0 && ((String)origOrdStrings.get(idxOfDuplicate)).equals(lowerCaseOrdStr)) continue;
            if (idxOfDuplicate >= 0) {
                origOrdStrings.remove(idxOfDuplicate);
                newOrds.remove(idxOfDuplicate);
                cats.remove(idxOfDuplicate);
            }
            origOrdStrings.add(origOrdStr);
            if (lowerCaseOrdStr.startsWith("history:")) {
                newOrds.add(HistoryCategoryUtil.convertToShorthand(ord, Sys.getStation().getStationName()));
            } else {
                newOrds.add(lowerCaseOrd);
            }
            cats.add(oMap.getCategoryMask(i));
        }
        this.set(ordMap, (BValue)BOrdToCategoryMap.make(newOrds.toArray(EMPTY_ORDS), cats.toArray(EMPTY_MASKS)), Context.skipValidate);
    }

    @Override
    public void serviceStarted() throws Exception {
        this.convertLegacyOrdsInMap();
    }

    @Override
    public void serviceStopped() throws Exception {
    }

    @Override
    public void started() throws Exception {
        this.rebuildLookup();
        this.thread = new UpdateThread();
        this.thread.start();
    }

    @Override
    public void stopped() throws Exception {
        this.lookup = null;
        if (this.thread != null) {
            this.thread.kill();
        }
        this.thread = null;
    }

    @Override
    public void added(Property prop, Context cx) {
        super.added(prop, cx);
        if (this.isRunning()) {
            this.rebuildLookup();
        }
    }

    @Override
    public void removed(Property prop, BValue old, Context cx) {
        super.removed(prop, old, cx);
        if (this.isRunning()) {
            this.rebuildLookup();
        }
    }

    @Override
    public void changed(Property prop, Context cx) {
        if (this.isRunning() && cx != Context.skipValidate && ordMap.equals(prop)) {
            this.convertLegacyOrdsInMap();
        }
        super.changed(prop, cx);
    }

    @Override
    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkContextForSuperUser(this, cx);
        BIRestrictedComponent.checkParentForRestrictedComponent(parent, this);
    }

    void rebuildLookup() {
        BCategory[] lookup = new BCategory[16];
        SlotCursor<Property> c = this.getProperties();
        while (c.nextComponent()) {
            BValue child = c.get();
            if (!(child instanceof BCategory)) continue;
            BCategory cat = (BCategory)child;
            int index = cat.getIndex();
            if (index <= 0) {
                cat.setStatus(BStatus.disabled);
                cat.setFaultCause("");
                continue;
            }
            if (lookup.length <= index) {
                int len = Math.max(lookup.length * 2, index + 1);
                if (len < 10) {
                    len = 10;
                }
                BCategory[] temp = new BCategory[len];
                System.arraycopy(lookup, 0, temp, 0, lookup.length);
                lookup = temp;
            }
            if (lookup[index] != null) {
                cat.setStatus(BStatus.fault);
                cat.setFaultCause("Duplicate index with " + lookup[index].getName());
                continue;
            }
            lookup[index] = cat;
            ((BAbstractCategory)child).setStatus(BStatus.ok);
            ((BAbstractCategory)child).setFaultCause("");
        }
        this.lookup = lookup;
    }

    void rebuildFilters() {
        this.rebuildLookup();
    }

    public void doUpdate() {
        long t2;
        long t1 = Clock.ticks();
        BCategoryMask[] working = new BCategoryMask[256];
        for (int i = 0; i < working.length; ++i) {
            working[i] = BCategoryMask.NULL;
        }
        BStation station = Sys.getStation();
        if (station != null) {
            ComponentSlotMap slotMap = (ComponentSlotMap)station.fw(1);
            slotMap.updateDeepOr(working, 0);
        }
        this.lastUpdateTicks = t2 = Clock.ticks();
        this.lastUpdateDuration = t2 - t1;
    }

    @NiagaraRpc(permissions="r", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox), @Transport(type=TransportType.web)})
    public void updateRpc(Context cx) {
        this.update();
    }

    @NiagaraRpc(permissions="R", transports={@Transport(type=TransportType.fox)})
    public List<String> retrieveDeepOrMasks(List<String> ords, Context cx) {
        return ords.stream().map(ord -> {
            BCategoryMask mask = BCategoryMask.NULL;
            try {
                BObject obj = BOrd.make(ord).relativizeToSession().get(this, cx);
                if (cx != null && cx.getUser() != null && obj instanceof BIProtected && !cx.getUser().getPermissionsFor((BIProtected)((Object)obj)).hasOperatorRead()) {
                    return mask.encodeToString();
                }
                if (obj.isComponent()) {
                    BComponent comp = obj.asComponent();
                    mask = ((ComponentSlotMap)comp.fw(1)).getDeepOrCategoryMask();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mask.encodeToString();
        }).collect(Collectors.toList());
    }

    @Override
    public void checkRemove(Property property, Context context) {
        BValue value = this.get(property);
        if (value instanceof BCategory && Sys.getStation() != null) {
            BRoleService roleService = BRoleService.getService();
            if (roleService == null) {
                throw new LocalizableRuntimeException("baja", "category.removal.cannotFindValidRoleService");
            }
            List<String> roles = roleService.getRoleIds();
            for (String roleId : roles) {
                BIRole role = roleService.getRole(roleId);
                if (role == null) {
                    throw new LocalizableRuntimeException("baja", "category.removal.cannotFindValidRoleService", new String[]{roleId});
                }
                BPermissionsMap pmap = role.getPermissions();
                if (pmap.isSuperUser()) continue;
                for (BCategory category : this.getCategories()) {
                    if (category.getIndex() != ((BCategory)value).getIndex() || pmap.getPermissions(category.getIndex()) == BPermissions.none) continue;
                    throw new LocalizableRuntimeException("baja", "category.removal.categoryIsReferenced", new String[]{((BComplex)value).getName(), roleId});
                }
            }
        }
        super.checkRemove(property, context);
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        if (this.isRunning() && context != null && context.getUser() != null) {
            return CategoryValidator.INSTANCE;
        }
        return null;
    }

    @Override
    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (this.isRunning() && context != null && context.getUser() != null) {
            return CategoryValidator.INSTANCE;
        }
        return null;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.toTop("webEditors:UxCategoryBrowser");
        agents.toTop("wbutil:CategoryBrowser");
        return PxUtil.movePxViewsToTop(agents);
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        if (this.lookup != null) {
            out.startProps("CategoryService");
            out.prop((Object)"lastUpdateTicks", BRelTime.toString(Clock.ticks() - this.lastUpdateTicks));
            out.prop((Object)"lastUpdateDuration", BRelTime.toString(this.lastUpdateDuration));
            out.endProps();
            out.startTable(true);
            out.trTitle("Lookup Table [" + this.lookup.length + "]", 2);
            for (int i = 0; i < this.lookup.length; ++i) {
                if (this.lookup[i] == null) continue;
                out.tr("" + i, this.lookup[i].getName());
            }
            out.endTable();
        }
        super.spy(out);
    }

    class UpdateThread
    extends Thread {
        boolean alive;

        UpdateThread() {
            super("CategoryService:Update");
            this.alive = true;
            this.setDaemon(true);
            this.setPriority(this.getPriority() - 1);
        }

        public void kill() {
            this.alive = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.alive) {
                try {
                    Thread.sleep(5000L);
                    long period = BCategoryService.this.getUpdatePeriod().getMillis();
                    if (period == 0L) continue;
                    if (period < 1000L) {
                        period = 1000L;
                    }
                    if (Clock.ticks() - BCategoryService.this.lastUpdateTicks < period) continue;
                    BCategoryService.this.doUpdate();
                }
                catch (InterruptedException period) {
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.log(Level.FINE, "Unexpected error in CategoryService's update thread", e);
                }
            }
        }
    }
}

