/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util.jar;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.util.jar.ModuleEntry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ModuleFile
extends JarFile {
    File file;
    public JarFile zip;
    URL url;
    long openTime;
    boolean verify = true;
    private Set<ReopenHandler> reopenHandlers;

    public ModuleFile(File file) throws IOException {
        this(file, true);
    }

    public ModuleFile(File file, boolean verify) throws IOException {
        super(file, verify);
        if (!verify) {
            NiagaraBasicPermission loadUnverifiedPermission = new NiagaraBasicPermission("LOAD_UNVERIFIED_MODULE");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)loadUnverifiedPermission);
            }
        }
        this.verify = verify;
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(file));
        }
        this.file = file;
        this.zip = new JarFile(file, verify);
        this.url = file.toURI().toURL();
        this.openTime = file.lastModified();
    }

    public void check() {
        if (this.file.lastModified() != this.openTime) {
            try {
                System.out.println("WARNING: JarFile.reopen: " + this.file);
                this.zip.close();
                this.zip = new JarFile(this.file, this.verify);
                if (this.reopenHandlers != null) {
                    this.reopenHandlers.stream().forEach(h -> h.onReopen(this.zip));
                }
                this.openTime = this.file.lastModified();
            }
            catch (Exception e) {
                System.out.println("  " + e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.zip != null) {
            this.zip.close();
        }
        this.zip = null;
        super.close();
    }

    public File getFile() {
        return this.file;
    }

    public URL getFileURL() {
        return this.url;
    }

    @Override
    public Enumeration<JarEntry> entries() {
        this.check();
        return super.entries();
    }

    @Override
    public ModuleEntry getJarEntry(String path) {
        this.check();
        JarEntry entry = this.zip.getJarEntry(path);
        if (entry != null) {
            return new ModuleEntry(this, entry);
        }
        return null;
    }

    public URL getResource(String path) {
        ModuleEntry entry = this.getJarEntry(path);
        if (entry != null) {
            return entry.getURL();
        }
        return null;
    }

    public String toString() {
        return this.file.toString();
    }

    public void addReopenHandler(ReopenHandler handler) {
        if (this.reopenHandlers == null) {
            this.reopenHandlers = new HashSet<ReopenHandler>();
        }
        this.reopenHandlers.add(handler);
    }

    public boolean removeReopenHandler(ReopenHandler handler) {
        return this.reopenHandlers != null && this.reopenHandlers.remove(handler);
    }

    @FunctionalInterface
    public static interface ReopenHandler {
        public void onReopen(JarFile var1);
    }
}

