/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.sys.schema.ComponentSlotMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.category.BCategoryMask;
import javax.baja.io.BIContextEncodable;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.virtual.BVirtualComponentSpace;

public class ValueByteBuffer
extends ByteBuffer {
    static final int VERSION = 1;
    protected static final int PROPERTY_SLOT = 1;
    protected static final int ACTION_SLOT = 2;
    protected static final int TOPIC_SLOT = 3;
    private boolean encodeTransients;
    private Context encodeContext = null;

    public static ValueByteBuffer make(byte[] buf, int len) {
        return new ValueByteBuffer(buf, len);
    }

    public static ValueByteBuffer make(byte[] buf) {
        return new ValueByteBuffer(buf);
    }

    public static ValueByteBuffer make(int initialCapacity) {
        return new ValueByteBuffer(initialCapacity);
    }

    public static ValueByteBuffer make() {
        return new ValueByteBuffer();
    }

    public static byte[] marshal(BObject value) throws IOException {
        ValueByteBuffer encoder = new ValueByteBuffer();
        encoder.encode(value);
        return encoder.toByteArray();
    }

    public static BObject unmarshal(byte[] bytes) throws Exception {
        ValueByteBuffer decoder = new ValueByteBuffer(bytes);
        return decoder.decode();
    }

    protected ValueByteBuffer(byte[] buf, int len) {
        super(buf, len);
    }

    protected ValueByteBuffer(byte[] buf) {
        super(buf);
    }

    protected ValueByteBuffer(int initialCapacity) {
        super(initialCapacity);
    }

    protected ValueByteBuffer() {
        this(64);
    }

    public boolean isEncodeTransients() {
        return this.encodeTransients;
    }

    public boolean setEncodeTransients(boolean encodeTransients) {
        boolean old = this.encodeTransients;
        this.encodeTransients = encodeTransients;
        return old;
    }

    public void setEncodeContext(Context context) {
        this.encodeContext = context;
    }

    public void encode(BObject value) throws IOException {
        this.encode(null, value, Integer.MAX_VALUE);
    }

    public void encode(String name, BObject value, int depth) throws IOException {
        this.writeByte(1);
        this.writeBoolean(true);
        this.writeByte(1);
        this.wname(name);
        this.wflags(-1);
        this.wfacets(null);
        this.wtype(value);
        if (value.isComponent()) {
            BComponent comp = (BComponent)value;
            Object handle = comp.getHandle();
            this.whandle(handle);
            BCategoryMask cats = comp.getCategoryMask();
            this.wcategories(cats);
            this.writeBoolean(false);
        }
        this.encodeValue(value, depth);
    }

    public BObject decode() throws Exception {
        byte ver = this.readByte();
        if (ver != 1) {
            throw new IllegalStateException("Version mismatch " + ver + " != " + 1);
        }
        BObject value = this.parseSlot(null);
        if (value == null) {
            throw new IllegalStateException("Error parsing value");
        }
        return value;
    }

    protected void encodeValueSpecial(BObject value) throws IOException {
    }

    protected void decodeValueSpecial(BObject value) throws Exception {
    }

    private void encodeSlot(BObject parent, Slot slot, boolean forceType, int depth) throws IOException {
        if (slot == null) {
            this.writeBoolean(false);
            return;
        }
        int flags = this.getSlotFlags(parent, slot);
        boolean isProp = slot.isProperty();
        Property prop = isProp ? (Property)slot : null;
        BValue value = isProp ? this.getPropertyValue(parent, prop) : null;
        boolean flagsOnly = false;
        if (!this.encodeTransients && (flags & 2) != 0) {
            if (value != null && slot.isFrozen() && value.isComponent()) {
                flagsOnly = false;
            } else if (isProp && slot.isFrozen() && flags != slot.getDefaultFlags()) {
                flagsOnly = true;
            } else {
                this.writeBoolean(false);
                return;
            }
        }
        boolean skipValue = false;
        skipValue = isProp && !flagsOnly ? slot.isFrozen() && !value.isComponent() && prop.isEquivalentToDefaultValue(value) : true;
        if (flags == slot.getDefaultFlags() && skipValue) {
            this.writeBoolean(false);
            return;
        }
        this.writeBoolean(true);
        boolean actionOrTopic = false;
        if (slot.isProperty()) {
            this.writeByte(1);
        } else if (slot.isAction()) {
            actionOrTopic = true;
            this.writeByte(2);
        } else if (slot.isTopic()) {
            actionOrTopic = true;
            this.writeByte(3);
        } else {
            throw new IllegalStateException("Slot is not a property, action, or topic");
        }
        this.wname(slot.getName());
        this.wflags(flags);
        if (actionOrTopic) {
            return;
        }
        BFacets facets = slot.getFacets();
        this.wfacets(facets);
        this.wtype(value);
        if (value instanceof BComponent) {
            BComponent comp = (BComponent)value;
            Object handle = comp.getHandle();
            this.whandle(handle);
            BCategoryMask cats = comp.getCategoryMask();
            this.wcategories(cats);
            this.writeBoolean(depth == 0 || comp.getComponentSpace() instanceof BVirtualComponentSpace && !((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded());
        }
        if (prop != null && !skipValue) {
            this.encodeValue(value, depth - 1);
        } else {
            this.writeBoolean(false);
        }
    }

    private void encodeValue(BObject value, int depth) throws IOException {
        this.encodeValueSpecial(value);
        if (value.isSimple()) {
            this.writeBoolean(true);
            this.wvalue((BSimple)value);
        } else if (!value.getType().is(BStatusValue.TYPE) || !this.encodeStatusValue(value)) {
            if (value.isComponent() && depth >= 0 || (value.isComplex() || value instanceof BIPropertyContainer) && !value.isComponent()) {
                SlotCursor<Slot> c;
                SlotCursor<Slot> slotCursor = c = value.isComplex() ? ((BComplex)value).getSlots() : ((BIPropertyContainer)((Object)value)).getSlots();
                while (c.next()) {
                    this.writeBoolean(true);
                    this.encodeSlot(value, c.slot(), false, depth);
                }
                this.writeBoolean(false);
            } else {
                this.writeBoolean(false);
            }
        }
    }

    private int getSlotFlags(BObject parent, Slot slot) {
        if (parent instanceof BIPropertyContainer) {
            return ((BIPropertyContainer)((Object)parent)).getFlags(slot);
        }
        if (parent instanceof BComplex) {
            return ((BComplex)parent).getFlags(slot);
        }
        return -1;
    }

    private BValue getPropertyValue(BObject parent, Property prop) {
        if (parent instanceof BIPropertyContainer) {
            return ((BIPropertyContainer)((Object)parent)).get(prop);
        }
        if (parent instanceof BComplex) {
            return ((BComplex)parent).get(prop);
        }
        return null;
    }

    void parseSlots(BObject parent) throws Exception {
        while (this.readBoolean()) {
            this.parseSlot(parent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    BObject parseSlot(BObject parent) throws Exception {
        boolean isStatusValue;
        BObject object;
        block32: {
            Property prop;
            if (!this.readBoolean()) {
                return null;
            }
            byte ename = this.readByte();
            if (ename != 1 && ename != 2 && ename != 3) {
                throw new IllegalStateException("Unknown element <" + ename + ">");
            }
            String name = this.rname();
            int flags = this.rflags();
            BFacets facets = null;
            BTypeSpec type = null;
            Object handle = null;
            BCategoryMask cats = null;
            boolean stub = false;
            if (ename == 1) {
                facets = this.rfacets();
                type = this.rtype();
                if (type != null && type.getResolvedType().is(BComponent.TYPE)) {
                    handle = this.rhandle();
                    cats = this.rcategories();
                    stub = this.readBoolean();
                }
            }
            Slot slot = null;
            if (parent != null) {
                if (name == null) {
                    throw new IllegalStateException("Missing name attribute");
                }
                Slot slot2 = slot = parent.isComplex() ? ((BComplex)parent).getSlot(name) : ((BIPropertyContainer)((Object)parent)).getSlot(name);
            }
            if (slot != null) {
                if (flags >= 0) {
                    try {
                        if (parent.isComplex()) {
                            ((BComplex)parent).setFlags(slot, flags, Context.decoding);
                        } else {
                            ((BIPropertyContainer)((Object)parent)).setFlags(slot, flags, Context.decoding);
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                if (!slot.isProperty()) {
                    return null;
                }
            } else {
                if (ename == 2) {
                    System.out.println("Missing frozen action: " + parent.getType() + " " + name);
                    return null;
                }
                if (ename == 3) {
                    System.out.println("Missing frozen topic: " + name);
                    return null;
                }
            }
            if ((object = this.newInstance(name, prop = (Property)slot, type)) == null) {
                return null;
            }
            this.decodeValueSpecial(object);
            isStatusValue = false;
            if (object.isSimple()) {
                if (!this.readBoolean()) return null;
                object = this.rvalue((BSimple)object);
            } else if (object.getType() == BStatusNumeric.TYPE || object.getType() == BStatusBoolean.TYPE || object.getType() == BStatusEnum.TYPE || object.getType() == BStatusString.TYPE) {
                isStatusValue = true;
                if (!this.readBoolean()) return null;
                object = this.decodeStatusValue(object);
            }
            if (object.isComponent()) {
                ((ComponentSlotMap)object.fw(1)).setHandle(handle);
                if (!stub) {
                    ((ComponentSlotMap)object.fw(1)).setBrokerPropsLoaded(true);
                }
                if (cats != null) {
                    ((BComponent)object).setCategoryMask(cats, Context.decoding);
                }
            }
            if (parent != null) {
                if (prop != null) {
                    if (!prop.isFrozen()) {
                        throw new IllegalStateException("Duplicate slot " + parent.getType().getTypeName() + "." + name);
                    }
                    try {
                        if (parent.isComplex()) {
                            ((BComplex)parent).set(prop, (BValue)object, Context.decoding);
                            break block32;
                        }
                        ((BIPropertyContainer)((Object)parent)).set(prop, (BValue)object, Context.decoding);
                    }
                    catch (Exception e) {
                        System.out.println("Cannot set property " + parent.getType().getTypeName() + "." + name + ": " + e);
                    }
                } else if (parent instanceof BIPropertyContainer) {
                    ((BIPropertyContainer)((Object)parent)).add(name, (BValue)object, flags, facets, Context.decoding);
                } else {
                    System.out.println("Missing slot " + parent.getType().getTypeName() + "." + name);
                }
            }
        }
        if (!object.isComplex() && !(object instanceof BIPropertyContainer) || isStatusValue) return object;
        this.parseSlots(object);
        return object;
    }

    private BObject newInstance(String name, Property prop, BTypeSpec typeSpec) {
        if (typeSpec == null || typeSpec.isNull()) {
            if (prop != null) {
                return prop.getDefaultValue();
            }
            System.out.println("Missing frozen property: " + name);
            return null;
        }
        try {
            return typeSpec.getInstance();
        }
        catch (TypeNotFoundException e) {
            System.out.println("Type \"" + e.getMessage() + "\" not found: " + name);
            return null;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Cannot instantiate type '" + typeSpec + "'");
        }
    }

    private boolean encodeStatusValue(BObject value) throws IOException {
        BStatusValue x;
        BStatus status = null;
        if (value.getType() == BStatusNumeric.TYPE) {
            this.writeBoolean(true);
            x = (BStatusNumeric)value;
            this.writeDouble(((BStatusNumeric)x).getValue());
            status = x.getStatus();
        } else if (value.getType() == BStatusBoolean.TYPE) {
            this.writeBoolean(true);
            x = (BStatusBoolean)value;
            this.writeBoolean(((BStatusBoolean)x).getValue());
            status = x.getStatus();
        } else if (value.getType() == BStatusEnum.TYPE) {
            this.writeBoolean(true);
            x = (BStatusEnum)value;
            this.wtype(((BStatusEnum)x).getValue());
            ((BStatusEnum)x).getValue().encode((DataOutput)((Object)this));
            status = x.getStatus();
        } else if (value.getType() == BStatusString.TYPE) {
            this.writeBoolean(true);
            x = (BStatusString)value;
            this.writeUTF(((BStatusString)x).getValue());
            status = x.getStatus();
        } else {
            return false;
        }
        boolean writeStatus = !status.equals(BStatus.DEFAULT);
        this.writeBoolean(writeStatus);
        if (writeStatus) {
            status.encode((DataOutput)((Object)this));
        }
        return true;
    }

    private BObject decodeStatusValue(BObject value) throws IOException {
        if (value.getType() == BStatusNumeric.TYPE) {
            ((BStatusNumeric)value).setValue(this.readDouble());
        } else if (value.getType() == BStatusBoolean.TYPE) {
            ((BStatusBoolean)value).setValue(this.readBoolean());
        } else if (value.getType() == BStatusEnum.TYPE) {
            BTypeSpec t = this.rtype();
            BSimple s = (BSimple)t.getInstance();
            ((BStatusEnum)value).setValue((BEnum)s.decode((DataInput)((Object)this)));
        } else if (value.getType() == BStatusString.TYPE) {
            ((BStatusString)value).setValue(this.readUTF());
        } else {
            return value;
        }
        if (this.readBoolean()) {
            ((BStatusValue)value).setStatus((BStatus)BStatus.DEFAULT.decode((DataInput)((Object)this)));
        }
        return value;
    }

    private ValueByteBuffer wname(String name) throws IOException {
        this.writeBoolean(name != null);
        if (name != null) {
            this.writeUTF(name);
        }
        return this;
    }

    private String rname() throws IOException {
        if (this.readBoolean()) {
            return this.readUTF();
        }
        return null;
    }

    private ValueByteBuffer wtype(BObject object) throws IOException {
        boolean valid = object != null;
        this.writeBoolean(valid);
        if (valid) {
            object.getType().getTypeSpec().encode((DataOutput)((Object)this));
        }
        return this;
    }

    private BTypeSpec rtype() throws IOException {
        if (this.readBoolean()) {
            return (BTypeSpec)BTypeSpec.DEFAULT.decode((DataInput)((Object)this));
        }
        return null;
    }

    private ValueByteBuffer wflags(int flags) throws IOException {
        this.writeInt(flags);
        return this;
    }

    private int rflags() throws IOException {
        return this.readInt();
    }

    private ValueByteBuffer whandle(Object handle) throws IOException {
        boolean valid = handle != null;
        this.writeBoolean(valid);
        if (valid) {
            this.writeUTF(String.valueOf(handle));
        }
        return this;
    }

    private Object rhandle() throws IOException {
        if (this.readBoolean()) {
            return this.readUTF();
        }
        return null;
    }

    private ValueByteBuffer wcategories(BCategoryMask cats) throws IOException {
        boolean valid = cats != null && !cats.isNull();
        this.writeBoolean(valid);
        if (valid) {
            cats.encode((DataOutput)((Object)this));
        }
        return this;
    }

    private BCategoryMask rcategories() throws IOException {
        if (this.readBoolean()) {
            return (BCategoryMask)BCategoryMask.DEFAULT.decode((DataInput)((Object)this));
        }
        return BCategoryMask.NULL;
    }

    private ValueByteBuffer wfacets(BFacets facets) throws IOException {
        boolean valid = facets != null && !facets.isNull();
        this.writeBoolean(valid);
        if (valid) {
            facets.encode((DataOutput)((Object)this));
        }
        return this;
    }

    private BFacets rfacets() throws IOException {
        if (this.readBoolean()) {
            return (BFacets)BFacets.DEFAULT.decode((DataInput)((Object)this));
        }
        return BFacets.NULL;
    }

    private ValueByteBuffer wvalue(BSimple simple) throws IOException {
        if (simple instanceof BIContextEncodable) {
            ((BIContextEncodable)((Object)simple)).encode((DataOutput)((Object)this), this.encodeContext);
        } else {
            simple.encode((DataOutput)((Object)this));
        }
        return this;
    }

    private BSimple rvalue(BSimple simple) throws IOException {
        if (simple instanceof BIContextEncodable) {
            return (BSimple)((BIContextEncodable)((Object)simple)).decode((DataInput)((Object)this), this.encodeContext);
        }
        return (BSimple)simple.decode((DataInput)((Object)this));
    }
}

