/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.util.IPrefixLoggable;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;

public final class PrefixLogUtil {
    public static final String NULL = "null";

    private PrefixLogUtil() {
    }

    public static void logWithPrefix(Logger log, Level level, Supplier<String> messageSupplier, Object origin) {
        PrefixLogUtil.logWithPrefix(log, level, messageSupplier, null, origin);
    }

    public static void logWithPrefix(Logger log, Level level, String message, Object origin) {
        PrefixLogUtil.logWithPrefix(log, level, () -> message, null, origin);
    }

    public static void logWithPrefix(Logger log, Level level, String message, Throwable throwable, Object origin) {
        PrefixLogUtil.logWithPrefix(log, level, () -> message, throwable, origin);
    }

    public static void logWithPrefix(Logger log, Level level, Supplier<String> messageSupplier, Throwable throwable, Object origin) {
        if (log.isLoggable(level)) {
            String prefixed = String.format("@%s | %s", PrefixLogUtil.prefix(origin), messageSupplier.get());
            if (throwable != null) {
                log.log(level, prefixed, throwable);
            } else {
                log.log(level, prefixed);
            }
        }
    }

    private static String prefix(Object origin) {
        StringBuilder builder = new StringBuilder();
        Optional<IPrefixLoggable> loggable = PrefixLogUtil.findLoggable(origin);
        if (loggable.isPresent()) {
            builder.append(loggable.get().identifierForLogs());
        } else if (origin != null) {
            builder.append(origin.getClass().getSimpleName());
        }
        return builder.toString();
    }

    private static Optional<IPrefixLoggable> findLoggable(Object origin) {
        IPrefixLoggable parentLoggable;
        BObject originObj;
        IPrefixLoggable loggable = null;
        if (origin instanceof IPrefixLoggable) {
            loggable = (IPrefixLoggable)origin;
        } else if (origin instanceof BObject && (originObj = (BObject)origin).isComplex() && (parentLoggable = PrefixLogUtil.getParent(originObj.asComplex(), IPrefixLoggable.class)) != null) {
            loggable = parentLoggable;
        }
        return Optional.ofNullable(loggable);
    }

    private static <T> T getParent(BComplex complex, Class<T> parentTypeToSeek) {
        BComplex parent;
        for (parent = complex.getParent(); parent != null && !parentTypeToSeek.isAssignableFrom(parent.getType().getTypeClass()); parent = parent.getParent()) {
        }
        return (T)parent;
    }
}

